/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.todo;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.todo.servlet.HttpServletModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Button {
    private String url;
    private String text;
    private Map<String, String> parameters;

    public Button() {
    }

    public Button(String text, String url) {
        this.text = text;
        this.url = url;
    }

    public Button(String text, String url, String parameterName, String parameterValue) {
        this(text, url);
        this.addParameter(parameterName, parameterValue);
    }

    public Button(String text, String url, Map<String, String> parameters) {
        this(text, url);
        this.parameters = parameters;
    }

    public void addParameter(String parameterName, String parameterValue) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(parameterName, parameterValue);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String toHtml(Kml model) {
        StringBuffer html = new StringBuffer();
        if (this.url.startsWith("http://")) {
            StringBuffer urlToUse = new StringBuffer(this.url);
        } else if (model instanceof HttpServletModel) {
            HttpServletModel httpServleModel = (HttpServletModel)model;
        } else {
            throw new IllegalArgumentException("Button has an url that is not absolute (does not starts with 'http://'). Then the model must be an instance of the HttpServletModel class.");
        }
        if (this.parameters != null) {
            for (String string : this.parameters.keySet()) {
            }
        }
        return html.toString();
    }

    public String encodeURL(String url, HttpServletRequest request) {
        int indexQuestionMark = url.indexOf("?");
        if (indexQuestionMark < 0) {
            return String.valueOf(url) + ";jsessionid=" + request.getSession().getId();
        }
        return String.valueOf(url.substring(0, indexQuestionMark)) + ";jsessionid=" + request.getSession().getId() + url.substring(indexQuestionMark);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

