/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.todo;

import java.util.ArrayList;
import java.util.Collection;
import org.boehn.kmlframework.coordinates.CartesianCoordinate;
import org.boehn.kmlframework.coordinates.Coordinate;
import org.boehn.kmlframework.coordinates.EarthCoordinate;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.kml.KmlException;
import org.boehn.kmlframework.todo.GraphicalModelElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalModel
implements GraphicalModelElement {
    private Collection<GraphicalModelElement> elements;
    private Integer visibleFrom;
    private Integer visibleTo;

    public Collection<GraphicalModelElement> getElements() {
        return this.elements;
    }

    public void setElements(Collection<GraphicalModelElement> elements) {
        this.elements = elements;
    }

    public void addGraphicalModelElement(GraphicalModelElement graphicalModelElement) {
        if (this.elements == null) {
            this.elements = new ArrayList<GraphicalModelElement>();
        }
        this.elements.add(graphicalModelElement);
    }

    public Integer getVisibleFrom() {
        return this.visibleFrom;
    }

    public void setVisibleFrom(Integer visibleFrom) {
        this.visibleFrom = visibleFrom;
    }

    public Integer getVisibleTo() {
        return this.visibleTo;
    }

    public void setVisibleTo(Integer visibleTo) {
        this.visibleTo = visibleTo;
    }

    @Override
    public Collection<Coordinate> getCoordinates() {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (GraphicalModelElement element : this.elements) {
            coordinates.addAll(element.getCoordinates());
        }
        return coordinates;
    }

    @Override
    public void addKml(Element parentElement, Kml model, Document xmlDocument, EarthCoordinate location, Double rotation, CartesianCoordinate localReferenceCoordinate, CartesianCoordinate scale) throws KmlException {
        if (this.elements != null) {
            for (GraphicalModelElement element : this.elements) {
                element.addKml(parentElement, model, xmlDocument, location, rotation, localReferenceCoordinate, scale);
            }
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer("GraphicalModel:\n");
        text.append("   visibleFrom: " + this.visibleFrom + "\n");
        text.append("   visibleTo: " + this.visibleTo + "\n");
        text.append("   elements: " + this.elements);
        return text.toString();
    }
}

