use strict;
use Test::More tests => 2;
use File::Basename 'dirname';
use Spreadsheet::ReadSXC;
use XML::Parser;
use Data::Dumper;

my $d = dirname($0);

my $workbook_ref = Spreadsheet::ReadSXC::read_sxc("$d/NewAPI.ods");

my $expected = {
           '3D' => [],
           '2D' => [
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Affected Charts'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Pie'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Bar'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Bar, Scatter'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Net'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Scatter'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Stock'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Instructions:',
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       "Click \x{201e}Create Charts\x{201c} to create 5 Charts",
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Then Click on any other Button to see some other things happen',
                       undef,
                       undef
                     ]
                   ],
           'Data' => [
                       [
                         'X',
                         'Y',
                         undef,
                         undef,
                         'Jan',
                         'Feb',
                         'Mar',
                         'Apr',
                         'May',
                         'Jun'
                       ],
                       [
                         '0',
                         '0.07',
                         undef,
                         'Berlin',
                         '2,001',
                         '1,987',
                         '500',
                         '200',
                         '1,000',
                         '1,500'
                       ],
                       [
                         '0.16',
                         '0.22',
                         undef,
                         'Hamburg',
                         '3,000',
                         '2,000',
                         '600',
                         '160',
                         '900',
                         '1,600'
                       ],
                       [
                         '0.31',
                         '0.41',
                         undef,
                         'Bremen',
                         '2,156',
                         '1,800',
                         '800',
                         '180',
                         '800',
                         '1,000'
                       ],
                       [
                         '0.47',
                         '0.51',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '0.63',
                         '0.63',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '0.79',
                         '0.72',
                         undef,
                         'Date',
                         'Volume',
                         'Open',
                         'Low',
                         'High',
                         'Close',
                         undef
                       ],
                       [
                         '0.94',
                         '0.82',
                         undef,
                         'Apr 7, 00',
                         '15,000,000 K',
                         '$88.75',
                         '$88.88',
                         '$94.50',
                         '$92.69',
                         undef
                       ],
                       [
                         '1.1',
                         '0.95',
                         undef,
                         'Apr 8, 00',
                         '14,652,562 K',
                         '$92.69',
                         '$87.00',
                         '$95.50',
                         '$93.69',
                         undef
                       ],
                       [
                         '1.26',
                         '0.96',
                         undef,
                         'Apr 9, 00',
                         '15,070,589 K',
                         '$93.69',
                         '$91.00',
                         '$96.50',
                         '$92.00',
                         undef
                       ],
                       [
                         '1.41',
                         '1.01',
                         undef,
                         'Apr 10, 00',
                         '15,207,571 K',
                         '$92.00',
                         '$90.00',
                         '$97.50',
                         '$93.00',
                         undef
                       ],
                       [
                         '1.57',
                         '1.04',
                         undef,
                         'Apr 11, 00',
                         '14,869,716 K',
                         '$93.00',
                         '$90.00',
                         '$98.50',
                         '$93.60',
                         undef
                       ],
                       [
                         '1.73',
                         '1.05',
                         undef,
                         'Apr 12, 00',
                         '15,225,943 K',
                         '$93.60',
                         '$87.00',
                         '$99.50',
                         '$93.80',
                         undef
                       ],
                       [
                         '1.88',
                         '1.03',
                         undef,
                         'Apr 13, 00',
                         '15,243,446 K',
                         '$93.80',
                         '$88.00',
                         '$100.50',
                         '$94.00',
                         undef
                       ],
                       [
                         '2.04',
                         '0.96',
                         undef,
                         'Apr 14, 00',
                         '14,889,873 K',
                         '$94.00',
                         '$89.00',
                         '$101.50',
                         '$93.00',
                         undef
                       ],
                       [
                         '2.2',
                         '0.83',
                         undef,
                         'Apr 15, 00',
                         '14,781,243 K',
                         '$93.00',
                         '$90.00',
                         '$100.00',
                         '$92.00',
                         undef
                       ],
                       [
                         '2.36',
                         '0.76',
                         undef,
                         'Apr 16, 00',
                         '15,132,068 K',
                         '$92.00',
                         '$88.00',
                         '$96.00',
                         '$92.00',
                         undef
                       ],
                       [
                         '2.51',
                         '0.62',
                         undef,
                         'Apr 17, 00',
                         '15,253,822 K',
                         '$92.00',
                         '$89.00',
                         '$95.00',
                         '$93.00',
                         undef
                       ],
                       [
                         '2.67',
                         '0.51',
                         undef,
                         'Apr 18, 00',
                         '14,919,019 K',
                         '$93.00',
                         '$93.00',
                         '$97.00',
                         '$95.00',
                         undef
                       ],
                       [
                         '2.83',
                         '0.37',
                         undef,
                         'Apr 19, 00',
                         '14,972,533 K',
                         '$95.00',
                         '$84.00',
                         '$95.00',
                         '$91.00',
                         undef
                       ],
                       [
                         '2.98',
                         '0.19',
                         undef,
                         'Apr 20, 00',
                         '14,642,786 K',
                         '$91.00',
                         '$87.00',
                         '$100.00',
                         '$97.00',
                         undef
                       ],
                       [
                         '3.14',
                         '0.07',
                         undef,
                         'Apr 21, 00',
                         '14,804,376 K',
                         '$97.00',
                         '$91.00',
                         '$98.00',
                         '$96.00',
                         undef
                       ],
                       [
                         '3.3',
                         '-0.15',
                         undef,
                         'Apr 22, 00',
                         '14,907,452 K',
                         '$96.00',
                         '$92.00',
                         '$102.00',
                         '$95.00',
                         undef
                       ],
                       [
                         '3.46',
                         '-0.22',
                         undef,
                         'Apr 23, 00',
                         '15,319,376 K',
                         '$95.00',
                         '$91.00',
                         '$96.00',
                         '$93.00',
                         undef
                       ],
                       [
                         '3.61',
                         '-0.4',
                         undef,
                         'Apr 24, 00',
                         '15,066,118 K',
                         '$93.00',
                         '$94.00',
                         '$99.00',
                         '$98.00',
                         undef
                       ],
                       [
                         '3.77',
                         '-0.49',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '3.93',
                         '-0.63',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '4.08',
                         '-0.74',
                         undef,
                         'CDU',
                         'SPD',
                         "Gr\x{fc}ne",
                         'FDP',
                         'PDS',
                         'Andere',
                         'Summe'
                       ],
                       [
                         '4.24',
                         '-0.8',
                         undef,
                         '34.29%',
                         '35.43%',
                         '11.43%',
                         '8.57%',
                         '4.57%',
                         '5.71%',
                         undef
                       ],
                       [
                         '4.4',
                         '-0.92',
                         undef,
                         '1200',
                         '1240',
                         '400',
                         '300',
                         '160',
                         '200',
                         '3500'
                       ],
                       [
                         '4.56',
                         '-0.94',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '4.71',
                         '-0.92',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '4.87',
                         '-0.99',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.03',
                         '-0.93',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.18',
                         '-0.81',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.34',
                         '-0.75',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.5',
                         '-0.64',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.65',
                         '-0.5',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.81',
                         '-0.39',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.97',
                         '-0.29',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '6.13',
                         '-0.06',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '6.28',
                         '0.09',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ]
                     ]
         };

is_deeply $workbook_ref, $expected, "NewAPI.ods gets parsed identically"
    or diag Dumper $workbook_ref;

$workbook_ref = Spreadsheet::ReadSXC::read_sxc("$d/NewAPI.ods", {    StandardCurrency    => 1,
    StandardDate        => 1,
    StandardTime        => 1,
});

my $expected = {
           '2D' => [
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Affected Charts'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Pie'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Bar'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Bar, Scatter'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Net'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Scatter'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Stock'
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Instructions:',
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       "Click \x{201e}Create Charts\x{201c} to create 5 Charts",
                       undef,
                       undef
                     ],
                     [
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       undef,
                       'Then Click on any other Button to see some other things happen',
                       undef,
                       undef
                     ]
                   ],
           '3D' => [],
           'Data' => [
                       [
                         'X',
                         'Y',
                         undef,
                         undef,
                         '2000-01-01',
                         '2000-02-01',
                         '2000-03-01',
                         '2000-04-01',
                         '2000-05-01',
                         '2000-06-01'
                       ],
                       [
                         '0',
                         '0.0736160629771725',
                         undef,
                         'Berlin',
                         '2001',
                         '1987',
                         '500',
                         '200',
                         '1000',
                         '1500'
                       ],
                       [
                         '0.15707963267949',
                         '0.222381328196949',
                         undef,
                         'Hamburg',
                         '3000',
                         '2000',
                         '600',
                         '160',
                         '900',
                         '1600'
                       ],
                       [
                         '0.314159265358979',
                         '0.407497597612808',
                         undef,
                         'Bremen',
                         '2156',
                         '1800',
                         '800',
                         '180',
                         '800',
                         '1000'
                       ],
                       [
                         '0.471238898038469',
                         '0.509797219370413',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '0.628318530717959',
                         '0.63395633752449',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '0.785398163397448',
                         '0.719141179928584',
                         undef,
                         'Date',
                         'Volume',
                         'Open',
                         'Low',
                         'High',
                         'Close',
                         undef
                       ],
                       [
                         '0.942477796076938',
                         '0.817336001844437',
                         undef,
                         '2000-04-07',
                         '15000000',
                         '88.75',
                         '88.875',
                         '94.5',
                         '92.6875',
                         undef
                       ],
                       [
                         '1.09955742875643',
                         '0.949218778830976',
                         undef,
                         '2000-04-08',
                         '14652562',
                         '92.6875',
                         '87',
                         '95.5',
                         '93.6875',
                         undef
                       ],
                       [
                         '1.25663706143592',
                         '0.959774132620732',
                         undef,
                         '2000-04-09',
                         '15070589',
                         '93.6875',
                         '91',
                         '96.5',
                         '92',
                         undef
                       ],
                       [
                         '1.41371669411541',
                         '1.01017825625409',
                         undef,
                         '2000-04-10',
                         '15207571',
                         '92',
                         '90',
                         '97.5',
                         '93',
                         undef
                       ],
                       [
                         '1.5707963267949',
                         '1.04025523422298',
                         undef,
                         '2000-04-11',
                         '14869716',
                         '93',
                         '90',
                         '98.5',
                         '93.6',
                         undef
                       ],
                       [
                         '1.72787595947439',
                         '1.04753199951172',
                         undef,
                         '2000-04-12',
                         '15225943',
                         '93.6',
                         '87',
                         '99.5',
                         '93.8',
                         undef
                       ],
                       [
                         '1.88495559215388',
                         '1.02786291206465',
                         undef,
                         '2000-04-13',
                         '15243446',
                         '93.8',
                         '88',
                         '100.5',
                         '94',
                         undef
                       ],
                       [
                         '2.04203522483337',
                         '0.958401671062797',
                         undef,
                         '2000-04-14',
                         '14889873',
                         '94',
                         '89',
                         '101.5',
                         '93',
                         undef
                       ],
                       [
                         '2.19911485751286',
                         '0.830847150364955',
                         undef,
                         '2000-04-15',
                         '14781243',
                         '93',
                         '90',
                         '100',
                         '92',
                         undef
                       ],
                       [
                         '2.35619449019234',
                         '0.758422682219809',
                         undef,
                         '2000-04-16',
                         '15132068',
                         '92',
                         '88',
                         '96',
                         '92',
                         undef
                       ],
                       [
                         '2.51327412287183',
                         '0.61750874736503',
                         undef,
                         '2000-04-17',
                         '15253822',
                         '92',
                         '89',
                         '95',
                         '93',
                         undef
                       ],
                       [
                         '2.67035375555132',
                         '0.508331188555977',
                         undef,
                         '2000-04-18',
                         '14919019',
                         '93',
                         '93',
                         '97',
                         '95',
                         undef
                       ],
                       [
                         '2.82743338823081',
                         '0.368970261437009',
                         undef,
                         '2000-04-19',
                         '14972533',
                         '95',
                         '84',
                         '95',
                         '91',
                         undef
                       ],
                       [
                         '2.9845130209103',
                         '0.18734508575333',
                         undef,
                         '2000-04-20',
                         '14642786',
                         '91',
                         '87',
                         '100',
                         '97',
                         undef
                       ],
                       [
                         '3.14159265358979',
                         '0.0695369149416393',
                         undef,
                         '2000-04-21',
                         '14804376',
                         '97',
                         '91',
                         '98',
                         '96',
                         undef
                       ],
                       [
                         '3.29867228626928',
                         '-0.148695695469987',
                         undef,
                         '2000-04-22',
                         '14907452',
                         '96',
                         '92',
                         '102',
                         '95',
                         undef
                       ],
                       [
                         '3.45575191894877',
                         '-0.217646287234005',
                         undef,
                         '2000-04-23',
                         '15319376',
                         '95',
                         '91',
                         '96',
                         '93',
                         undef
                       ],
                       [
                         '3.61283155162826',
                         '-0.401230768200599',
                         undef,
                         '2000-04-24',
                         '15066118',
                         '93',
                         '94',
                         '99',
                         '98',
                         undef
                       ],
                       [
                         '3.76991118430775',
                         '-0.489735482416856',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '3.92699081698724',
                         '-0.633651622065608',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '4.08407044966673',
                         '-0.74060350042111',
                         undef,
                         'CDU',
                         'SPD',
                         "Gr\x{fc}ne",
                         'FDP',
                         'PDS',
                         'Andere',
                         'Summe'
                       ],
                       [
                         '4.24115008234622',
                         '-0.795288510043229',
                         undef,
                         '0.342857142857143',
                         '0.354285714285714',
                         '0.114285714285714',
                         '0.0857142857142857',
                         '0.0457142857142857',
                         '0.0571428571428571',
                         undef
                       ],
                       [
                         '4.39822971502571',
                         '-0.922963238013719',
                         undef,
                         '1200',
                         '1240',
                         '400',
                         '300',
                         '160',
                         '200',
                         '3500'
                       ],
                       [
                         '4.5553093477052',
                         '-0.936119316703055',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '4.71238898038469',
                         '-0.921722266134677',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '4.86946861306418',
                         '-0.985978999383097',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.02654824574367',
                         '-0.933540629292918',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.18362787842316',
                         '-0.814248187085184',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.34070751110265',
                         '-0.751500933485474',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.49778714378214',
                         '-0.643419808952295',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.65486677646163',
                         '-0.498992516447254',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.81194640914112',
                         '-0.388155431380584',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '5.96902604182061',
                         '-0.287117767544654',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '6.1261056745001',
                         '-0.0589241128694329',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ],
                       [
                         '6.28318530717959',
                         '0.0883249840644768',
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef,
                         undef
                       ]
                     ]
         };

is_deeply $workbook_ref, $expected, "NewAPI.ods gets parsed identically with standardized values"
    or diag Dumper $workbook_ref;

