/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright (C) 2009--2020 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once


/////////////////////// StdLib includes


/////////////////////// Qt includes
#include <QDialog>
#include <QPlainTextEdit>


/////////////////////// pappsomspp includes
#include <limits>
#include <pappsomspp/trace/trace.h>
#include <pappsomspp/trace/maptrace.h>
#include <pappsomspp/processing/combiners/mzintegrationparams.h>

#include "libXpertMass/PeakCentroid.hpp"
#include "libXpertMass/MassPeakShaperConfig.hpp"
#include "libXpertMass/MassPeakShaper.hpp"


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "MassPeakShaperConfigWidget.hpp"


namespace Ui
{
class MassPeakShaperConfigDlg;
}


namespace MsXpS
{

namespace libXpertMassGui
{


class DECLSPEC MassPeakShaperConfigDlg : public QDialog
{
  Q_OBJECT

  public:
  MassPeakShaperConfigDlg(
    QWidget *program_window_p,
    const QString &applicationName,
    const QString &description);

  virtual ~MassPeakShaperConfigDlg();

  void writeSettings(const QString &configSettingsFilePath);
  void readSettings(const QString &configSettingsFilePath);

  // The normalizing intensity usually is the greatest intensity in the cluster
  // centroids that is to be used for normalization of the peaks in the cluster.
  void setNormalizingIntensity(double new_max_intensity);

  protected:
  Ui::MassPeakShaperConfigDlg *mp_ui;
  MassPeakShaperConfigWidget *mp_massPeakShaperConfigWidget = nullptr;

  QWidget *mp_parent = nullptr;

  QString m_applicationName;

  libXpertMass::MassPeakShaperConfig m_config;

  void closeEvent(QCloseEvent *event);

  void setupDialog();

signals:

  void updatedMassPeakShaperConfigSignal(const libXpertMass::MassPeakShaperConfig &config);
};

} // namespace libXpertMassGui

} // namespace MsXpS

