// license:BSD-3-Clause
// copyright-holders:Sergey Svishchev

/***************************************************************************

    Netlist (palestra) to be included from palestra.cpp

    https://www.mobygames.com/game/dedicated-console/palestra-02
        database entry
    http://www.ccjvq.com/slydc/palestra02.rar
        schematics
    http://discreteconsoles.blogspot.com/2015/10/emulation-of-ay-3-8500-1-and-clones-soon.html
        photos
    https://www.youtube.com/watch?v=3XZxkTvOF4Y
        gameplay video

    To do:
    - write 74H53 device
    - trace the boards (schematic contains several errors)
    - hook up inputs

***************************************************************************/

#ifndef __PLIB_PREPROCESSOR__
	#define NL_PROHIBIT_BASEH_INCLUDE   1
	#include "netlist/devices/net_lib.h"
#endif

#define SLOW_BUT_ACCURATE 0

NETLIST_START(palestra)

//  SOLVER(Solver, 10000000) to maintain accuracy when SLOW is set and CAP()s are connected
	SOLVER(Solver, 50000)
//  PARAM(Solver.PARALLEL, 0) // Don't do parallel solvers
	PARAM(Solver.ACCURACY, 1e-5) // ???
//  PARAM(Solver.LTE,     1e-4) // Default is not enough for paddle control if using LTE
	PARAM(NETLIST.USE_DEACTIVATE, 1)

	ANALOG_INPUT(V5, 5)
	ALIAS(VCC, V5) // no-ttl-dip devices need VCC!

	TTL_INPUT(high, 1)
	TTL_INPUT(low, 0)
	NET_C(VCC, high.VCC, low.VCC)
	NET_C(GND, high.GND, low.GND)

/*
 * board A2 -- score display
 */

	TTL_7410_NAND(A2D1_1, N0X3, N1X4, N0X5)
	TTL_7410_NAND(A2D1_2, A2D1_1.Q, A2D1_1.Q, A2D1_1.Q)

	TTL_7410_NAND(A2D1_3, N1X3, N0X4, N0X5)
	TTL_7400_NAND(A2D9_1, A2D1_3.Q, A2D1_3.Q)
	TTL_7400_NAND(A2D9_2, P_EX, a2x28)
	TTL_7400_NAND(A2D9_3, A2D9_2.Q, A2D9_2.Q)

	TTL_7410_NAND(A2D2_1, N1X3, N1X4, N0X5)
	TTL_7410_NAND(A2D2_2, N0X3, N0X4, N1X5)
	TTL_7410_NAND(A2D2_3, N1X3, N0X4, N1X5)
	TTL_7410_NAND(A2D10_1, A2D2_1.Q, A2D2_2.Q, A2D2_3.Q)
	TTL_7400_NAND(A2D9_4, A2D2_2.Q, A2D2_2.Q)

	TTL_7410_NAND(A2D3_1, N1Y3, N1Y4, N0Y5)
	TTL_7410_NAND(A2D3_2, N0Y3, N0Y4, N1Y5)
	TTL_7410_NAND(A2D4_1, N1Y3, N0Y4, N1Y5)
	TTL_7410_NAND(A2D4_2, N0Y3, N1Y4, N1Y5)
	TTL_7410_NAND(A2D4_3, N1Y3, N1Y4, N1Y5)
	TTL_7400_NAND(A2D11_1, A2D3_1.Q, A2D3_1.Q)
	TTL_7400_NAND(A2D11_2, A2D4_1.Q, A2D4_1.Q)
	TTL_7400_NAND(A2D11_3, A2D4_3.Q, A2D4_3.Q)
	TTL_7400_NAND(A2D11_4, A2D2_1.Q, A2D2_1.Q)
	TTL_7400_NAND(A2D12_1, A2D2_3.Q, A2D2_3.Q)
	TTL_7400_NAND(A2D12_2, A2D4_2.Q, A2D4_3.Q)
	TTL_7410_NAND(A2D3_3, A2D4_1.Q, A2D3_1.Q, A2D3_2.Q)

	// player 1 score counter
	TTL_7493(A2D5, SCORE1, A2D5.QA, A2D8_2.Q, A2D8_2.Q)
	TTL_7400_NAND(A2D8_1, A2D5.QD, A2D5.QB)
	TTL_7400_NAND(A2D8_2, A2D8_1.Q, RESET)
	TTL_7474(A2D6_1, A2D8_2.Q, A2D6_1.QQ, high, RESET)

	// player 2 score counter
	TTL_7493(A2D7, SCORE2, A2D7.QA, A2D8_4.Q, A2D8_4.Q)
	TTL_7400_NAND(A2D8_3, A2D7.QD, A2D7.QB)
	TTL_7400_NAND(A2D8_4, A2D8_3.Q, RESET)
	TTL_7474(A2D6_2, A2D8_4.Q, A2D6_2.QQ, high, RESET)

	TTL_7450_ANDORINVERT(A2D13_1, a2x3, N0X6, a2x4, N1X6)
	TTL_7450_ANDORINVERT(A2D13_2, a2x5, N0X6, a2x6, N1X6)
	TTL_7450_ANDORINVERT(A2D14_1, a2x7, N0X6, a2x8, N1X6)
	TTL_7450_ANDORINVERT(A2D14_2, a2x10, N0X6, a2x9, N1X6)
	TTL_7450_ANDORINVERT(A2D15_1, A2D6_1.Q, N0X6, A2D6_2.Q, N1X6)
//  NET_C(A2D17_1.A, a2x21) // XXX typo in schematics?

	TTL_7400_NAND(A2D16_1, A2D13_1.Q, A2D13_1.Q)
	TTL_7400_NAND(A2D16_2, A2D13_2.Q, A2D13_2.Q)
	TTL_7400_NAND(A2D16_3, A2D14_1.Q, A2D14_1.Q)
	TTL_7400_NAND(A2D16_4, A2D14_2.Q, A2D14_2.Q)

	TTL_7420_NAND(A2D17_1, A2D13_1.Q, A2D13_2.Q, A2D14_1.Q, A2D14_2.Q)
	TTL_7420_NAND(A2D17_2, A2D13_2.Q, A2D14_1.Q, a2x17, A2D14_2.Q)
	TTL_7420_NAND(A2D18_1, A2D13_1.Q, A2D14_1.Q, A2D14_2.Q, a2x18)
	TTL_7420_NAND(A2D18_2, a2x17, A2D14_1.Q, a2x18, A2D14_2.Q)
	TTL_7410_NAND(A2D19_1, A2D13_1.Q, a2x19, A2D13_2.Q)
	TTL_7410_NAND(A2D19_2, a2x17, A2D13_2.Q, a2x19)
	TTL_7410_NAND(A2D19_3, A2D13_1.Q, a2x18, a2x19)
	TTL_7410_NAND(A2D10_2, a2x19, a2x18, a2x17)
	TTL_7400_NAND(A2D12_4, a2x17, a2x20)

//

	TTL_7450_ANDORINVERT(A2D15_2, a2x16, A2D9_3.Q, A2D9_3.Q, a2x15)
	TTL_7420_NAND(A2D20_1, a2x11, a2x12, a2x22, a2x25)
	TTL_7410_NAND(A2D21_1, a2x11, a2x22, a2x29)
	TTL_7400_NAND(A2D12_3, A2D21_1.Q, A2D21_1.Q)
	TTL_7410_NAND(A2D21_2, A2D12_3.Q, a2x13, a2x21)
	TTL_7410_NAND(A2D21_3, A2D12_3.Q, a2x14, a2x25)
	TTL_7430_NAND(A2D22, a2x15, a2x22, a2x23, a2x24, a2x29, P_CX, P_CX, P_CX)
	TTL_7420_NAND(A2D20_2, a2x15, P_AX, a2x26, a2x27)
	TTL_7430_NAND(A2D23, P_CX, a2x16, a2x22, a2x24, a2x25, a2x26, a2x29, a2x30)
	TTL_7410_NAND(A2D10_3, P_AX, a2x16, a2x23)
	TTL_7430_NAND(A2D24, A2D15_2.Q, A2D20_1.Q, A2D21_2.Q, A2D21_3.Q, A2D22.Q, A2D20_2.Q, A2D23.Q, A2D10_3.Q)

	TTL_7400_NAND(A2D25_1, a2x26, a2x26)
	TTL_7400_NAND(A2D25_2, A2D25_1.Q, a2x28)
#if 1
	CAP(A2Cx, CAP_P(11)) // XXX value not specified
	NET_C(a2x28, A2Cx.1)
	NET_C(A2Cx.2, A2D25_2.Q)
#endif

	// inputs
	ALIAS(RESET, N1X7)

	// outputs
	ALIAS(P_CYRG_X, A2D1_2.Q)
	ALIAS(P_CYRD_X, A2D9_1.Q)
	ALIAS(P_CYRW_X, A2D11_4.Q)
	ALIAS(P_CYRB_X, A2D9_4.Q)
	ALIAS(P_CYRA_X, A2D12_1.Q)
	ALIAS(P_AX, P_CYRA_X)
	ALIAS(P_BX, P_CYRB_X)
	ALIAS(P_CX, P_CYRW_X)
	ALIAS(P_DX, P_CYRG_X)
	ALIAS(P_EX, P_CYRD_X)
	ALIAS(GAME_OVER, A2D25_2.Q)
	ALIAS(SCORE_OUT, A2D24.Q)

	// test points
	ALIAS(a2x3, A2D5.QA)
	ALIAS(a2x4, A2D7.QA)
	ALIAS(a2x5, A2D5.QB)
	ALIAS(a2x6, A2D7.QB)
	ALIAS(a2x7, A2D5.QC)
	ALIAS(a2x8, A2D7.QC)
	ALIAS(a2x9, A2D7.QD)
	ALIAS(a2x10, A2D5.QD)
	ALIAS(a2x11, A2D10_1.Q)
	ALIAS(a2x12, A2D11_1.Q)
	ALIAS(a2x13, A2D11_2.Q)
	ALIAS(a2x14, A2D11_3.Q)
	ALIAS(a2x15, A2D3_3.Q)
	ALIAS(a2x16, A2D12_2.Q)
	ALIAS(a2x17, A2D16_1.Q)
	ALIAS(a2x18, A2D16_2.Q)
	ALIAS(a2x19, A2D16_3.Q)
	ALIAS(a2x20, A2D16_4.Q)
	ALIAS(a2x21, A2D17_1.Q)
	ALIAS(a2x22, A2D17_2.Q)
	ALIAS(a2x23, A2D18_1.Q)
	ALIAS(a2x24, A2D18_2.Q)
	ALIAS(a2x25, A2D19_1.Q)
	ALIAS(a2x26, A2D19_2.Q)
	ALIAS(a2x27, A2D19_3.Q)
	ALIAS(a2x28, A2D15_1.Q)
	ALIAS(a2x29, A2D10_2.Q)
	ALIAS(a2x30, A2D12_4.Q)

/*
 * board A3 -- sync generator
 */

#if SLOW_BUT_ACCURATE
	TTL_7400_NAND(A3D1_3, A3D5.QA, A3D5.QA)
	TTL_7400_NAND(A3D1_4, A3D1_3.Q, A3D2_1.Q)
#else
	TTL_7400_NAND(A3D1_4, N0X1, A3D2_1.Q)
#endif
	TTL_7420_NAND(A3D2_1, MOVE_LEFT, STOP_BALL, P_SPEED_X, GAME_OVER)
	TTL_7420_NAND(A3D2_2, MOVE_RIGHT, GAME_OVER, P_SPEED_X, STOP_BALL)

	// CLK1, CLK2, R1, R2  [14, 1, 2, 3]
#if SLOW_BUT_ACCURATE
	TTL_7493(A3D5, clk, A3D5.QA, A3D1_4.Q, a3x3)
#else
	TTL_7493(A3D5, low, N1X1, A3D1_4.Q, a3x3)
#endif
	TTL_7493(A3D6, A3D5.QD, A3D6.QA, A3D1_4.Q, a3x3)
	TTL_7400_NAND(A3D4_3, A3D5.QB, A3D5.QB)
	TTL_7400_NAND(A3D4_4, A3D5.QC, A3D5.QC)
	TTL_7400_NAND(A3D12_3, A3D4_3.Q, A3D4_4.Q)
	TTL_7430_NAND(A3D15, A3D12_3.Q, A3D12_3.Q, A3D5.QD, A3D6.QA, A3D6.QB, A3D6.QC, A3D6.QD, P_MY)
	TTL_7430_NAND(A3D16, A3D5.QD, A3D6.QA, A3D6.QB, A3D6.QC, A3D6.QD, A3D5.QC, A3D5.QB, A3D2_2.Q)
	TTL_7400_NAND(A3D12_4, N_M, N_M)
	TTL_7400_NAND(A3D17_1, N_M, N_M)
	TTL_7400_NAND(A3D20_1, A3D16.Q, A3D16.Q)

	TTL_7400_NAND(A3D1_1, MOVE_UP, P_SPEED_Y)
	TTL_7400_NAND(A3D1_2, P_SPEED_Y, MOVE_DOWN)
	TTL_7400_NAND(A3D4_1, N0X8, A3D1_1.Q)
	TTL_7410_NAND(A3D7_1, N1X7, A3D4_1.Q, A3D1_2.Q)
	// CLK, D, CLRQ, PREQ  [3, 2, 1, 4]
	TTL_7474(A3D8_1, A3D7_1.Q, A3D8_1.QQ, high, high)
	// CLK1, CLK2, R1, R2  [14, 1, 2, 3]
	TTL_7493(A3D13, A3D8_1.Q, A3D13.QA, a3x4, low) //A3D14.QD) XXX
	TTL_7493(A3D14, A3D13.QD, A3D14.QA, a3x4, low) //A3D14.QD) XXX
	TTL_7410_NAND(A3D7_2, A3D13.QC, A3D14.QA, A3D13.QD)
	TTL_7400_NAND(A3D26_4, A3D7_2.Q, A3D7_2.Q)
	TTL_7420_NAND(A3D3_2, A3D13.QB, A3D14.QB, a3x4, A3D14.QC)
	TTL_7400_NAND(A3D20_2, A3D3_2.Q, A3D3_2.Q)

	// outputs
	ALIAS(N_M, A3D15.Q)
	ALIAS(P_M1, A3D12_4.Q)
	ALIAS(P_M2, A3D17_1.Q)
	ALIAS(P_MY, A3D20_2.Q)

	// test points
	ALIAS(a3x3, A3D20_1.Q)
	ALIAS(a3x4, A3D26_4.Q)

// hsync

#if SLOW_BUT_ACCURATE
	MAINCLOCK(clk, 4000000.0)

#if 1
	CAP(A3C5, CAP_P(200))
	NET_C(clk, A3C5.1)
	NET_C(N1X1, A3C5.2)
//  NET_C(A3C5.2, A3D21.CLKB)
#endif

	// CLK1, CLK2, R1, R2  [14, 1, 2, 3]
	TTL_7493(A3D21, clk, N1X1, a3x6, a3x6)
	TTL_7493(A3D22, N1X4, N1X5, a3x6, a3x6)
	TTL_7400_NAND(A3D20_3, N1X1, N1X1)
	TTL_7400_NAND(A3D25_2, N1X2, N1X2)
	TTL_7400_NAND(A3D20_4, N1X3, N1X3)
	TTL_7400_NAND(A3D25_3, N1X4, N1X4)
	TTL_7400_NAND(A3D23_1, N1X5, N1X5)
	TTL_7400_NAND(A3D25_4, N1X6a, N1X6a)
	TTL_7400_NAND(A3D23_2, N1X6a, N1X6a)
	TTL_7400_NAND(A3D26_1, N0X6b, N0X6b)
	TTL_7400_NAND(A3D23_3, N1X7a, N1X7a)
	TTL_7400_NAND(A3D26_2, N0X7, N0X7)
	TTL_7400_NAND(A3D23_4, N1X8, N1X8)
	TTL_7430_NAND(A3D24, N1X1, N1X2, N1X3, N1X4, N1X5, N1X6a, N1X7a, N1X8)
	TTL_7400_NAND(A3D25_1, A3D24.Q, A3D24.Q)
#else
	ALIAS(clk, low)
	CLOCK(N1X1, 2000000.0)
	CLOCK(N1X2, 1000000.0)
	CLOCK(N1X3, 500000.0)
	CLOCK(N1X4, 250000.0)
	CLOCK(N1X5, 125000.0)
	CLOCK(N1X6a, 62500.0)
	CLOCK(N1X7a, 31250.0)
	CLOCK(N1X8, 15625.0)
	ALIAS(N1X6b, N1X6a)
	ALIAS(N1X7b, N1X7a)
	EXTCLOCK(N0X1, 2000000.0, "1,1")
	EXTCLOCK(N0X2, 1000000.0, "1,1")
	EXTCLOCK(N0X3, 500000.0, "1,1")
	EXTCLOCK(N0X4, 250000.0, "1,1")
	EXTCLOCK(N0X5, 125000.0, "1,1")
	EXTCLOCK(N0X6a, 62500.0, "1,1")
	EXTCLOCK(N0X7, 31250.0, "1,1")
	EXTCLOCK(N0X8, 15625.0, "1,1")
	PARAM(N0X1.OFFSET, -2.5e-7)
	PARAM(N0X2.OFFSET, -5e-7)
	PARAM(N0X3.OFFSET, -1e-6)
	PARAM(N0X4.OFFSET, -2e-6)
	PARAM(N0X5.OFFSET, -4e-6)
	PARAM(N0X6a.OFFSET, -8e-6)
	PARAM(N0X7.OFFSET, -1.6e-5)
	PARAM(N0X8.OFFSET, -3.2e-5)
	ALIAS(N0X6b, N0X6a)
#endif
	ALIAS(N1X7, N1X7a)
	ALIAS(N1X6, N1X6a)
	ALIAS(N0X6, N0X6a)
	TTL_7420_NAND(A3D27_1, N1X5, N0X6b, N0X7, N0X8)
	TTL_7420_NAND(A3D27_2, N1X5, N1X6a, N0X7, N0X8)
	TTL_7400_NAND(A3D26_3, A3D27_2.Q, A3D27_2.Q)

	// outputs
#if SLOW_BUT_ACCURATE
	ALIAS(N1X1, A3D21.QA)
	ALIAS(N1X2, A3D21.QB)
	ALIAS(N1X3, A3D21.QC)
	ALIAS(N1X4, A3D21.QD)
	ALIAS(N1X5, A3D22.QA)
	ALIAS(N1X6a, A3D22.QB)
	ALIAS(N1X7a, A3D22.QC)
	ALIAS(N1X8, A3D22.QD)
	ALIAS(N1X6b, A3D26_1.Q)
	ALIAS(N1X7b, A3D26_2.Q)

	ALIAS(N0X1, A3D20_3.Q)
	ALIAS(N0X2, A3D25_2.Q)
	ALIAS(N0X3, A3D20_4.Q)
	ALIAS(N0X4, A3D25_3.Q)
	ALIAS(N0X5, A3D23_1.Q)
	ALIAS(N0X6a, A3D25_4.Q)
	ALIAS(N0X6b, A3D23_2.Q)
	ALIAS(N0X7, A3D23_3.Q)
	ALIAS(N0X8, A3D23_4.Q)

	ALIAS(a3x6, A3D25_1.Q)
#endif

	ALIAS(HSYNC, A3D27_1.Q)
	ALIAS(STOPSOUND, A3D26_3.Q)

// vsync

	// CLK, D, CLRQ, PREQ  [3, 2, 1, 4]
	TTL_7474(A3D8_2, N0X8, A3D8_2.QQ, high, high)
	// CLK1, CLK2, R1, R2  [14, 1, 2, 3]
	TTL_7493(A3D10, A3D8_2.QQ, N1Y2, A3D12_1.Q, low) // N1Y9) XXX
	TTL_7493(A3D11, N1Y5, N1Y6, A3D12_1.Q, low) // N1Y9) XXX
	TTL_7400_NAND(A3D18_1, N1Y2, N1Y2)
	TTL_7400_NAND(A3D18_2, N1Y3, N1Y3)
	TTL_7400_NAND(A3D18_3, N1Y4, N1Y4)
	TTL_7400_NAND(A3D18_4, N1Y5, N1Y5)
	TTL_7400_NAND(A3D19_1, N1Y6, N1Y6)
	TTL_7400_NAND(A3D19_2, N1Y7, N1Y7)
	TTL_7400_NAND(A3D19_3, N1Y8, N1Y8)
	TTL_7400_NAND(A3D19_4, N1Y9, N1Y9)
	TTL_7410_NAND(A3D7_3, N1Y6, N1Y5, N1Y4)
	TTL_7400_NAND(A3D12_1, A3D7_3.Q, A3D7_3.Q)

	TTL_7420_NAND(A3D3_1, N0Y4, N0Y5, N1Y3, N1Y2)
	TTL_7400_NAND(A3D4_2, A3D3_1.Q, A3D3_1.Q)
	TTL_7430_NAND(A3D9, N0Y8, N0Y7, N0Y6, N0Y5, N0Y4, A3D3_1.Q, N0Y9, N0Y9)
	TTL_7400_NAND(A3D12_2, N_6LINES, N_6LINES)

	// outputs
	ALIAS(N1Y1, A3D8_2.Q)
	ALIAS(N1Y2, A3D10.QA)
	ALIAS(N1Y3, A3D10.QB)
	ALIAS(N1Y4, A3D10.QC)
	ALIAS(N1Y5, A3D10.QD)
	ALIAS(N1Y6, A3D11.QA)
	ALIAS(N1Y7, A3D11.QB)
	ALIAS(N1Y8, A3D11.QC)
	ALIAS(N1Y9, A3D11.QD)
	ALIAS(N0Y2, A3D18_1.Q)
	ALIAS(N0Y3, A3D18_2.Q)
	ALIAS(N0Y4, A3D18_3.Q)
	ALIAS(N0Y5, A3D18_4.Q)
	ALIAS(N0Y6, A3D19_1.Q)
	ALIAS(N0Y7, A3D19_2.Q)
	ALIAS(N0Y8, A3D19_3.Q)
	ALIAS(N0Y9, A3D19_4.Q)

	ALIAS(P_EY, A3D4_2.Q)
	ALIAS(N_6LINES, A3D9.Q)
	ALIAS(P_6LINES, A3D12_2.Q)

	// test points
	ALIAS(a3x5, clk)

/*
 * board A4 -- game logic
 */

// player 1

	// CLK, D, CLRQ, PREQ  [3, 2, 1, 4]
	TTL_7474(A4D1_1, A4D16_2.Q, a4x3, high, high)
	TTL_7400_NAND(A4D4_1, A4D1_2.QQ, A4D1_1.QQ)
	TTL_7400_NAND(A4D4_2, A4D4_1.Q, A4D4_1.Q)
	TTL_7474(A4D1_2, A4D7_2.Q, A4D1_2.Q, high, A4D1_1.QQ)

	TTL_7400_NAND(A4D2_1, tbc, G_SIZE)
	TTL_7400_NAND(A4D2_2, N1X8, A4D2_1.Q)
	// CLK1, CLK2, R1, R2  [14, 1, 2, 3]
	TTL_7493(A4D5, A4D2_2.Q, A4D5.QA, A4D4_1.Q, A4D4_1.Q)
	TTL_7400_NAND(A4D7_1, A4D5.QC, A4D5.QC)
	TTL_7400_NAND(A4D7_2, A4D5.QD, A4D5.QD)

// player 2

	// CLK, D, CLRQ, PREQ  [3, 2, 1, 4]
	TTL_7474(A4D3_1, A4D16_2.Q, a4x4, high, high)
	TTL_7400_NAND(A4D4_3, A4D3_2.QQ, A4D3_1.QQ)
	TTL_7400_NAND(A4D4_4, A4D4_3.Q, A4D4_3.Q)
	TTL_7474(A4D3_2, A4D7_4.Q, A4D3_2.Q, high, A4D3_1.QQ)

	TTL_7400_NAND(A4D2_3, tbc, G_SIZE2)
	TTL_7400_NAND(A4D2_4, N1X8, A4D2_3.Q)
	// CLK1, CLK2, R1, R2  [14, 1, 2, 3]
	TTL_7493(A4D6, A4D2_4.Q, A4D6.QA, A4D4_3.Q, A4D4_3.Q)
	TTL_7400_NAND(A4D7_3, A4D6.QC, A4D6.QC)
	TTL_7400_NAND(A4D7_4, A4D6.QD, A4D6.QD)

//

	TTL_7420_NAND(A4D9_1, P_M2, P_I1, A4D7_2.Q, A4D7_1.Q)
	TTL_7420_NAND(A4D9_2, P_M2, P_I1, A4D7_1.Q, A4D5.QC)
	TTL_7420_NAND(A4D10_1, P_M2, P_I1, A4D5.QD, A4D7_1.Q)
	TTL_7420_NAND(A4D10_2, P_M2, P_I1, A4D5.QC, A4D5.QD)

	TTL_7420_NAND(A4D11_1, P_M2, P_I2, A4D7_4.Q, A4D7_3.Q)
	TTL_7420_NAND(A4D11_2, P_M2, P_I2, A4D6.QC, A4D7_4.Q)
	TTL_7420_NAND(A4D12_1, P_M2, P_I2, A4D6.QD, A4D7_3.Q)
	TTL_7420_NAND(A4D12_2, P_M2, P_I2, A4D6.QC, A4D6.QD)

	TTL_7400_NAND(A4D8_1, P_BOTTOM_BORDER, P_MY)
	TTL_7400_NAND(A4D8_2, P_MY, P_TOP_BORDER)
	TTL_7400_NAND(A4D8_3, P_M2, P_I)

	// four RS flip-flops
	TTL_7410_NAND(A4D13_1, a4x5, A4D11_1.Q, A4D14_1.Q)
	TTL_7400_NAND(A4D14_1, A4D13_1.Q, A4D16_4.Q)
	TTL_7410_NAND(A4D13_2, a4x6, a4x9, A4D14_2.Q)
	TTL_7400_NAND(A4D14_2, A4D13_2.Q, A4D16_4.Q)
	TTL_7410_NAND(A4D15_1, a4x7, a4x10, A4D14_3.Q)
	TTL_7400_NAND(A4D14_3, A4D15_1.Q, A4D16_4.Q)
	TTL_7410_NAND(A4D15_2, a4x8, a4x11, A4D14_4.Q)
	TTL_7400_NAND(A4D14_4, A4D15_2.Q, A4D16_4.Q)

	TTL_7400_NAND(A4D16_1, N0Y3, P_6LINES)
	TTL_7400_NAND(A4D16_2, HSYNC, A4D16_1.Q)
	TTL_7400_NAND(A4D16_3, A4D16_1.Q, A4D16_1.Q)
	TTL_7400_NAND(A4D16_4, N0Y2, A4D16_3.Q)

	// five RS flip-flops
	TTL_7400_NAND(A4D8_4, a4x12, A4D13_3.Q)
	TTL_7410_NAND(A4D13_3, A4D8_4.Q, A4D14_4.Q, A4D14_1.Q)
	TTL_7400_NAND(A4D17_1, a4x12, A4D17_2.Q)
	TTL_7400_NAND(A4D17_2, A4D17_1.Q, A4D14_2.Q)
	TTL_7400_NAND(A4D17_3, a4x12, A4D17_4.Q)
	TTL_7400_NAND(A4D17_4, A4D17_3.Q, A4D14_3.Q)
	TTL_7420_NAND(A4D18_1, A4D14_1.Q, A4D14_2.Q, A4D8_1.Q, A4D18_2.Q)
	TTL_7420_NAND(A4D18_2, A4D18_1.Q, A4D14_3.Q, A4D14_4.Q, A4D8_2.Q)
	TTL_7400_NAND(A4D19_1, a4x12, A4D19_2.Q)
	TTL_7400_NAND(A4D19_2, A4D19_1.Q, a4x14)

// speed Y

	TTL_7400_NAND(A4D24_1, A4D16_4.Q, A4D16_4.Q)
	TTL_7400_NAND(A4D24_2, N1Y1, A4D24_1.Q)
	TTL_7400_NAND(A4D24_3, A4D24_2.Q, P_6LINES)
	TTL_7400_NAND(A4D24_4, A4D24_2.Q, A4D16_3.Q)
	TTL_7400_NAND(A4D21_1, A4D17_1.Q, A4D17_4.Q)
	TTL_7400_NAND(A4D21_2, A4D17_2.Q, A4D17_3.Q)
	TTL_7400_NAND(A4D21_3, A4D21_1.Q, A4D21_2.Q)
	TTL_7400_NAND(A4D21_4, A4D24_4.Q, G_ANGLE)
	TTL_7400_NAND(A4D25_2, A4D16_4.Q, G_ANGLE)
	TTL_7400_NAND(A4D25_3, A4D24_2.Q, G_ANGLE)

	TTL_7420_NAND(A4D28_1, P_6LINES, A4D17_1.Q, A4D17_3.Q, A4D21_4.Q)
	TTL_7420_NAND(A4D28_2, A4D16_3.Q, A4D13_3.Q, a4x13, A4D25_2.Q)
	TTL_7420_NAND(A4D20_2, A4D24_1.Q, A4D8_4.Q, a4x13, A4D25_3.Q)
	TTL_7410_NAND(A4D29_1, A4D28_1.Q, A4D28_2.Q, A4D20_2.Q)

// speed X

	// CLK1, CLK2, R1, R2  [14, 1, 2, 3]
	TTL_7493(A4D31, SOUND_GATE, A4D31.QA, SOUND_GATE, SOUND_GATE)
	TTL_7400_NAND(A4D30_3, A4D31.QB, A4D31.QB)
	TTL_7400_NAND(A4D30_4, A4D31.QD, A4D31.QD)
	TTL_7410_NAND(A4D29_3, A4D31.QC, A4D31.QB, A4D31.QD)

	TTL_7400_NAND(A4D25_1, A4D30_4.Q, G_SPEED_AUTO)
	TTL_7400_NAND(A4D25_4, G_SPEED_3, A4D25_1.Q)
	TTL_7400_NAND(A4D27_1, A4D30_3.Q, G_SPEED_AUTO)
	TTL_7400_NAND(A4D27_3, A4D27_1.Q, G_SPEED_4)
	TTL_7400_NAND(A4D27_4, A4D29_3.Q, G_SPEED_4)
//  TTL_74H53_AND_OR_INVERT(A4D32, tbc, tbc, A4D24_3.Q, A4D27_3.Q, A4D16_1.Q, A4D25_4.Q, A4D16_4.Q, A4D27_4.Q, G_SPEED_1)

// sound

	// CLK, D, CLRQ, PREQ  [3, 2, 1, 4]
	TTL_7474(A4D22_1, N1Y5, A4D22_1.QQ, high, A4D19_1.Q)
	TTL_7474(A4D22_2, A4D22_1.Q, A4D22_2.QQ, high, A4D19_1.Q)
	TTL_7400_NAND(A4D19_3, A4D22_2.QQ, A4D22_1.QQ)

	TTL_7420_NAND(A4D20_1, A4D8_2.Q, A4D8_1.Q, REFLECT_LEFT, REFLECT_RIGHT)
	TTL_7410_NAND(A4D15_3, A4D20_1.Q, A4D20_1.Q, A4D20_1.Q)
	TTL_7474(A4D23_1, low, low, A4D15_3.Q, A4D27_2.Q)
	TTL_7474(A4D23_2, N1Y5, A4D23_2.QQ, high, SOUND_GATE)
	TTL_7474(A4D26_1, N1Y5, A4D23_1.QQ, high, A4D26_1.QQ)
	TTL_7474(A4D26_2, A4D26_1.Q, A4D26_2.QQ, high, A4D23_1.QQ)
	TTL_7400_NAND(A4D27_2, A4D26_2.QQ, A4D26_1.QQ)

	TTL_7400_NAND(A4D19_4, A4D22_1.QQ, N0Y9)
	TTL_7400_NAND(A4D30_1, A4D26_1.QQ, N1Y4)
	TTL_7400_NAND(A4D30_2, N0Y3, A4D23_2.QQ)
	TTL_7410_NAND(A4D29_2, A4D19_4.Q, A4D30_1.Q, A4D30_2.Q)

	// outputs
	ALIAS(MOVE_UP, A4D18_1.Q)
	ALIAS(MOVE_DOWN, A4D18_2.Q)
//  ALIAS(P_SPEED_X, A4D32.Q)
	ALIAS(P_SPEED_X, low)
	ALIAS(P_SPEED_Y, A4D29_1.Q)
	ALIAS(P_I1Y, A4D4_2.Q)
	ALIAS(P_I2Y, A4D4_4.Q)
	ALIAS(SYNC_MIX, A4D16_2.Q)
	ALIAS(soundmix, A4D29_2.Q)

	// hacks
	ALIAS(G_SIZE, low)
	ALIAS(G_SIZE2, low)
	ALIAS(G_ANGLE, low)
	ALIAS(G_SPEED_1, low)
	ALIAS(G_SPEED_3, low)
	ALIAS(G_SPEED_4, low)
	ALIAS(G_SPEED_AUTO, low)

	// test points
	ALIAS(a4x3, N1Y1) // XXX player 1 input
	ALIAS(a4x4, N1Y1) // XXX player 2 input
	ALIAS(a4x5, A4D9_1.Q)
	ALIAS(a4x6, A4D9_2.Q)
	ALIAS(a4x7, A4D10_1.Q)
	ALIAS(a4x8, A4D10_2.Q)
	ALIAS(a4x9, A4D11_1.Q)
	ALIAS(a4x10, A4D12_1.Q)
	ALIAS(a4x11, A4D12_2.Q)
	ALIAS(a4x12, A4D8_3.Q)
	ALIAS(a4x13, A4D21_3.Q)
	ALIAS(a4x14, A4D19_2.Q)

/*
 * board A5 -- playfield composer
 */

	TTL_7410_NAND(A5D6_1, N1Y6, N0Y7, N0Y8)
	TTL_7400_NAND(A5D15_1, A5D6_1.Q, A5D6_1.Q)
	TTL_7410_NAND(A5D6_2, tbc, N0Y9, A5D15_1.Q)
	TTL_7410_NAND(A5D6_3, A5D15_1.Q, N1Y9, P_EY)
	TTL_7420_NAND(A5D5_2, A5D5_1.Q, SCORE_OUT, N0X1, A5D15_1.Q)
	TTL_7420_NAND(A5D7_1, N1Y8, N1Y6, N1Y7, tbc)
	TTL_7420_NAND(A5D7_2, tbc, N1Y7, N1Y6, N0Y8)
	TTL_7430_NAND(A5D8, N1X3, N1X4, N1X5, RESET, N0X1, N1Y1, A5D3_1.Q, A5D3_1.Q)

//

	TTL_7400_NAND(A5D1_1, N0X2, N0X1)
	TTL_7400_NAND(A5D1_3, N1X2, N1X1)
#if 0
	CAP(A5Cx, CAP_P(390))
	NET_C(N1X1, A5Cx.1)
	NET_C(A5Cx.2, A5D1_3.Q)
#endif

	TTL_7400_NAND(A5D2_1, G_TRAINING, G_RIGHT_LEFT)
	TTL_7400_NAND(A5D2_2, A5D2_1.Q, G_TRAINING)
	TTL_7400_NAND(A5D2_3, G_RIGHT_LEFT, G_SQUASH)
	TTL_7400_NAND(A5D2_4, A5D2_3.Q, G_SQUASH)

	TTL_7400_NAND(A5D3_1, G_TENNIS, G_VOLLEYBALL)
	TTL_7400_NAND(A5D3_2, G_VOLLEYBALL, A5D2_1.Q)
	TTL_7400_NAND(A5D3_3, G_FOOSBALL, A5D2_4.Q)
	TTL_7400_NAND(A5D3_4, G_FOOSBALL, A5D2_3.Q)
	TTL_7400_NAND(A5D4_1, G_VOLLEYBALL, A5D2_2.Q)
	TTL_7400_NAND(A5D4_2, G_FOOSBALL, A5D2_2.Q)
	TTL_7400_NAND(A5D4_3, A5D2_2.Q, N1X6)
	TTL_7400_NAND(A5D4_4, G_FOOSBALL, A5D2_1.Q)
	TTL_7400_NAND(A5D1_2, A5D2_1.Q, RESET)
	TTL_7420_NAND(A5D5_1, A5D4_3.Q, A5D2_3.Q, A5D2_4.Q, A5D1_2.Q)

//

	TTL_7420_NAND(A5D9_1, A5D16_1.Q, P_AX, P_I1Y, A5D3_2.Q)
	TTL_7420_NAND(A5D9_2, N0X8, N1X7, N1X6, N0X2)
	TTL_7420_NAND(A5D10_1, A5D16_1.Q, N1Y1, P_I2Y, A5D3_4.Q)
	TTL_7420_NAND(A5D10_2, N1X8, N1X7, RESET, N1X2)
	TTL_7420_NAND(A5D11_1, A5D16_2.Q, P_DX, P_I1Y, A5D3_3.Q)
	TTL_7420_NAND(A5D11_2, A5D4_1.Q, P_I2Y, P_EX, A5D16_2.Q)
	TTL_7430_NAND(A5D12, A5D1_1.Q, N1Y1, RESET, N1X7, N0X8, P_I1Y, A5D3_1.Q, A5D3_1.Q)
	TTL_7430_NAND(A5D13, A5D1_3.Q, P_DX, N1X6, N1X7, N1X8, P_I2Y, A5D3_1.Q, A5D3_1.Q)
	TTL_7420_NAND(A5D14_1, N0X8, RESET, N1X7, P_CX)
	TTL_7420_NAND(A5D14_2, N1X8, N1X6, N1X7, P_CX)

	TTL_7400_NAND(A5D15_2, A5D6_2.Q, A5D6_3.Q)
	TTL_7400_NAND(A5D15_3, A5D15_2.Q, N0X3)
	TTL_7410_NAND(A5D17_2, A5D7_1.Q, A5D3_1.Q, A5D1_4.Q)
	TTL_7400_NAND(A5D1_4, A5D17_2.Q, A5D7_2.Q)

	CAP(A5C5, CAP_P(390))
	TTL_7400_NAND(A5D16_1, A5D9_2.Q, A5D9_2.Q)
	NET_C(A5D9_2.Q, A5C5.1)
	NET_C(A5D16_1.Q, A5C5.2)
	TTL_7400_NAND(A5D16_2, A5D10_2.Q, A5D10_2.Q)

	TTL_7410_NAND(A5D17_1, A5D13.Q, A5D11_2.Q, A5D10_1.Q)
	TTL_7400_NAND(A5D16_4, A5D17_1.Q, A5D17_1.Q)
	TTL_7420_NAND(A5D18_1, A5D19_1.Q, N1Y1, A5D17_2.Q, A5D4_2.Q)
	TTL_7400_NAND(A5D19_1, A5D14_1.Q, A5D14_1.Q)
	TTL_7400_NAND(A5D19_2, A5D14_2.Q, A5D14_2.Q)

	CAP(A5C6, CAP_P(390))
	NET_C(A5C6.2, GND)
	NET_C(N_6LINES, A5C6.1)
	TTL_7400_NAND(A5D20_1, A5D6_2.Q, A5D20_2.Q)
	TTL_7400_NAND(A5D20_2, A5D20_1.Q, N_6LINES)
	TTL_7400_NAND(A5D20_3, N_6LINES, A5D20_4.Q)
	TTL_7400_NAND(A5D20_4, A5D20_3.Q, A5D6_3.Q)
	TTL_7400_NAND(A5D15_4, A5D6_3.Q, A5D20_4.Q)

	TTL_7410_NAND(A5D17_3, A5D9_1.Q, A5D11_1.Q, a5x3)
	TTL_7400_NAND(A5D16_3, P_I1, P_I1)

	TTL_7400_NAND(A5D21_1, A5D18_1.Q, A5D18_1.Q)
	TTL_7420_NAND(A5D18_2, A5D4_4.Q, A5D19_2.Q, N1Y1, A5D17_2.Q)
	TTL_7400_NAND(A5D19_3, A5D14_2.Q, A5D19_4.Q)
	TTL_7400_NAND(A5D19_4, A5D19_3.Q, A5D14_1.Q)
	TTL_7400_NAND(A5D21_2, A5D18_2.Q, A5D18_2.Q)
	TTL_7400_NAND(A5D22_2, A5D19_3.Q, A5D14_2.Q)

	CAP(A5C4, CAP_P(150))
	NET_C(SCORE_OUT, A5C4.1)
	NET_C(A5C4.2, A5D5_2.Q)
	TTL_7430_NAND(A5D23, A5C4.2, A5D8.Q, A5D16_3.Q, N_M, A5D15_3.Q, A5D18_1.Q, A5D18_2.Q, A5D16_4.Q)
	TTL_7400_NAND(A5D22_1, A5D2_4.Q, A5D2_4.Q)
	TTL_7400_NAND(A5D22_3, A5D2_3.Q, A5D2_3.Q)
	TTL_7410_NAND(A5D24_1, A5D16_3.Q, A5D16_4.Q, A5D16_4.Q)
	TTL_7400_NAND(A5D25_1, A5D21_1.Q, P_M1)
	TTL_7400_NAND(A5D25_2, A5D21_2.Q, P_M1)
	TTL_7400_NAND(A5D25_3, SERVE, A5D25_4.Q)
	TTL_7400_NAND(A5D25_4, A5D25_3.Q, A5D27_2.Q)

	TTL_7410_NAND(A5D26_1, SYNC_MIX, P_M1, tbc)
	TTL_7410_NAND(A5D26_2, P_M1, SYNC_MIX, STOPSOUND)
	TTL_7410_NAND(A5D24_2, SYNC_MIX, P_M1, MOVE_LEFT)
	TTL_7410_NAND(A5D24_3, P_M1, tbc, STOPSOUND)
	TTL_7410_NAND(A5D26_3, A5D27_2.Q, A5D26_2.Q, A5D26_1.Q)
	TTL_7420_NAND(A5D27_2, A5D26_3.Q, A5D24_3.Q, A5D24_2.Q, N0X6)

	TTL_7420_NAND(A5D27_1, a5x9, a5x7, a5x8, a5x5)
	TTL_7420_NAND(A5D28_1, A5D2_4.Q, A5D33_1.Q, P_I1, P_M1) // possible typo in schematic
	TTL_7420_NAND(A5D28_2, P_I2, P_M1, A5D31_3.Q, A5D22_3.Q)
	TTL_7420_NAND(A5D29_1, A5D22_1.Q, A5D33_1.Q, P_I1, P_M1)
	TTL_7420_NAND(A5D29_2, P_M1, A5D2_3.Q, A5D31_3.Q, P_I2)

	TTL_7420_NAND(A5D30_1, a5x14, a5x10, REFLECT_LEFT, MOVE_LEFT)
	TTL_7420_NAND(A5D30_2, A5D30_1.Q, A5D29_1.Q, a5x11, A5D25_2.Q)
	TTL_7410_NAND(A5D31_1, a5x14, A5D29_1.Q, REFLECT_RIGHT)
	TTL_7420_NAND(A5D32_1, A5D31_1.Q, REFLECT_LEFT, REFLECT_RIGHT, A5D32_2.Q)
	TTL_7420_NAND(A5D32_2, REFLECT_RIGHT, REFLECT_LEFT, A5D25_2.Q, A5D31_2.Q)
	TTL_7410_NAND(A5D31_2, a5x10, a5x11, A5D32_2.Q)

	TTL_7400_NAND(A5D21_3, MOVE_LEFT, A5D2_3.Q)
	TTL_7400_NAND(A5D21_4, tbc, A5D2_4.Q)
	TTL_7400_NAND(A5D22_4, A5D2_4.Q, A5D2_3.Q)
	TTL_7410_NAND(A5D31_3, REFLECT_RIGHT, A5D22_4.Q, A5D33_1.Q)
	TTL_7410_NAND(A5D33_1, A5D22_4.Q, A5D32_2.Q, A5D31_3.Q)
	TTL_7410_NAND(A5D33_2, A5D21_4.Q, SOUND_GATE, A5D33_1.Q)
	TTL_7410_NAND(A5D33_3, SOUND_GATE, A5D21_3.Q, A5D31_3.Q)

	ALIAS(tbc, low)
	ALIAS(G_TRAINING, low)
	ALIAS(G_RIGHT_LEFT, low)
	ALIAS(G_VOLLEYBALL, low)
	ALIAS(G_SQUASH, low)
	ALIAS(G_FOOSBALL, low)
	ALIAS(G_TENNIS, low)
	ALIAS(SERVE, low)

	// outputs
	ALIAS(videomix, A5D27_1.Q)
	ALIAS(P_I, A5D24_1.Q)
	ALIAS(P_I1, A5D17_3.Q)
	ALIAS(P_I2, A5D17_1.Q)
	ALIAS(P_TOP_BORDER, A5D20_2.Q)
	ALIAS(P_BOTTOM_BORDER, A5D20_3.Q)
	ALIAS(STOP_BALL, A5D25_3.Q)
	ALIAS(REFLECT_LEFT, A5D25_1.Q)
	ALIAS(MOVE_LEFT, A5D30_2.Q)
	ALIAS(REFLECT_RIGHT, A5D32_1.Q)
	ALIAS(MOVE_RIGHT, tbc)
	ALIAS(SOUND_GATE, A5D26_3.Q)
	ALIAS(SCORE1, A5D33_3.Q)
	ALIAS(SCORE2, A5D33_2.Q)

	// test points
	ALIAS(a5x3, A5D12.Q)
	ALIAS(a5x5, A5D22_2.Q)
	ALIAS(a5x6, A5D17_3.Q)
	ALIAS(a5x7, A5D15_4.Q)
	ALIAS(a5x8, A5D23.Q)
	ALIAS(a5x9, A5D20_1.Q)
	ALIAS(a5x10, A5D28_2.Q)
	ALIAS(a5x11, A5D29_2.Q)
	ALIAS(a5x12, A5D27_2.Q)
	ALIAS(a5x13, A5D28_2.Q)
	ALIAS(a5x14, A5D28_1.Q)

#if 0
	HINT(clk, NO_DEACTIVATE)
#endif

	// Connect power terminals

	NET_C(VCC, N1X1.VCC, N1X2.VCC, N1X3.VCC, N1X4.VCC, N1X5.VCC, N1X6a.VCC, N1X7a.VCC, N1X8.VCC)
	NET_C(GND, N1X1.GND, N1X2.GND, N1X3.GND, N1X4.GND, N1X5.GND, N1X7a.GND, N1X6a.GND, N1X8.GND)

NETLIST_END()

