/* -*- mode: C++; c-basic-offset: 4; indent-tabs-mode: nil -*- */
// vim: ft=cpp:expandtab:ts=8:sw=4:softtabstop=4:
#ident "$Id$"
/*
COPYING CONDITIONS NOTICE:

  This program is free software; you can redistribute it and/or modify
  it under the terms of version 2 of the GNU General Public License as
  published by the Free Software Foundation, and provided that the
  following conditions are met:

      * Redistributions of source code must retain this COPYING
        CONDITIONS NOTICE, the COPYRIGHT NOTICE (below), the
        DISCLAIMER (below), the UNIVERSITY PATENT NOTICE (below), the
        PATENT MARKING NOTICE (below), and the PATENT RIGHTS
        GRANT (below).

      * Redistributions in binary form must reproduce this COPYING
        CONDITIONS NOTICE, the COPYRIGHT NOTICE (below), the
        DISCLAIMER (below), the UNIVERSITY PATENT NOTICE (below), the
        PATENT MARKING NOTICE (below), and the PATENT RIGHTS
        GRANT (below) in the documentation and/or other materials
        provided with the distribution.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.

COPYRIGHT NOTICE:

  TokuFT, Tokutek Fractal Tree Indexing Library.
  Copyright (C) 2007-2013 Tokutek, Inc.

DISCLAIMER:

  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.

UNIVERSITY PATENT NOTICE:

  The technology is licensed by the Massachusetts Institute of
  Technology, Rutgers State University of New Jersey, and the Research
  Foundation of State University of New York at Stony Brook under
  United States of America Serial No. 11/760379 and to the patents
  and/or patent applications resulting from it.

PATENT MARKING NOTICE:

  This software is covered by US Patent No. 8,185,551.
  This software is covered by US Patent No. 8,489,638.

PATENT RIGHTS GRANT:

  "THIS IMPLEMENTATION" means the copyrightable works distributed by
  Tokutek as part of the Fractal Tree project.

  "PATENT CLAIMS" means the claims of patents that are owned or
  licensable by Tokutek, both currently or in the future; and that in
  the absence of this license would be infringed by THIS
  IMPLEMENTATION or by using or running THIS IMPLEMENTATION.

  "PATENT CHALLENGE" shall mean a challenge to the validity,
  patentability, enforceability and/or non-infringement of any of the
  PATENT CLAIMS or otherwise opposing any of the PATENT CLAIMS.

  Tokutek hereby grants to you, for the term and geographical scope of
  the PATENT CLAIMS, a non-exclusive, no-charge, royalty-free,
  irrevocable (except as stated in this section) patent license to
  make, have made, use, offer to sell, sell, import, transfer, and
  otherwise run, modify, and propagate the contents of THIS
  IMPLEMENTATION, where such license applies only to the PATENT
  CLAIMS.  This grant does not include claims that would be infringed
  only as a consequence of further modifications of THIS
  IMPLEMENTATION.  If you or your agent or licensee institute or order
  or agree to the institution of patent litigation against any entity
  (including a cross-claim or counterclaim in a lawsuit) alleging that
  THIS IMPLEMENTATION constitutes direct or contributory patent
  infringement, or inducement of patent infringement, then any rights
  granted to you under this License shall terminate as of the date
  such litigation is filed.  If you or your agent or exclusive
  licensee institute or order or agree to the institution of a PATENT
  CHALLENGE, then Tokutek may terminate any rights granted to you
  under this License.
*/

#ident "Copyright (c) 2007-2013 Tokutek Inc.  All rights reserved."
#ident "The technology is licensed by the Massachusetts Institute of Technology, Rutgers State University of New Jersey, and the Research Foundation of State University of New York at Stony Brook under United States of America Serial No. 11/760379 and to the patents and/or patent applications resulting from it."

#include "locktree_unit_test.h"

namespace toku {

static DBT *expected_a;
static DBT *expected_b;
static DESCRIPTOR expected_descriptor;
static int expected_comparison_magic = 55;

static int my_compare_dbts(DB *db, const DBT *a, const DBT *b) {
    invariant(db->cmp_descriptor == expected_descriptor);
    (void) a; 
    (void) b;
    return expected_comparison_magic;
}

// test that get/set userdata works, and that get_manager() works
void locktree_unit_test::test_misc(void) {
    locktree lt;
    DICTIONARY_ID dict_id = { 1 };
    toku::comparator my_dbt_comparator;
    my_dbt_comparator.create(my_compare_dbts, nullptr);
    lt.create(nullptr, dict_id, my_dbt_comparator);

    invariant(lt.get_userdata() == nullptr);
    int userdata;
    lt.set_userdata(&userdata);
    invariant(lt.get_userdata() == &userdata);
    lt.set_userdata(nullptr);
    invariant(lt.get_userdata() == nullptr);

    int r;
    DBT dbt_a, dbt_b;
    DESCRIPTOR_S d1, d2;
    expected_a = &dbt_a;
    expected_b = &dbt_b;

    toku::comparator cmp_d1, cmp_d2;
    cmp_d1.create(my_compare_dbts, &d1);
    cmp_d2.create(my_compare_dbts, &d2);

    // make sure the comparator object has the correct
    // descriptor when we set the locktree's descriptor
    lt.set_comparator(cmp_d1);
    expected_descriptor = &d1;
    r = lt.m_cmp(&dbt_a, &dbt_b);
    invariant(r == expected_comparison_magic);
    lt.set_comparator(cmp_d2);
    expected_descriptor = &d2;
    r = lt.m_cmp(&dbt_a, &dbt_b);
    invariant(r == expected_comparison_magic);

    lt.release_reference();
    lt.destroy();

    cmp_d1.destroy();
    cmp_d2.destroy();
    my_dbt_comparator.destroy();
}

} /* namespace toku */

int main(void) {
    toku::locktree_unit_test test;
    test.test_misc();
    return 0;
}
