/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef IconHelp_H
#include "IconHelp.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif

#ifndef XMList_H
#include "XMList.h"
#endif

#ifndef RequestPanel_H
#include "RequestPanel.h"
#endif

#ifndef HelpFactory_H
#include "HelpFactory.h"
#endif

#ifndef Parameter_H
#include "Parameter.h"
#endif

#ifndef Folder_H
#include "Folder.h"
#endif

#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef SyncFolders_H
#include "SyncFolders.h"
#endif


IconHelp::IconHelp(Widget parent, RequestPanel& owner, const Parameter& def):
	XHelp<UIIconHelp_c>(parent, owner, def), 
	FolderViewer(
		  Folder::folder("templates",
			  	owner.iconClass().defaultName(),
				param_.beautifiedName()))
{     
	Request interface = param_.interfaceRequest();
	classes_ = interface.get("class");

    FolderViewer::install(drag_);

	// Synchronize those two folders

	SyncFolders::add(
	
		  Folder::folder("templates",
			  	owner.iconClass().defaultName(),
				param_.beautifiedName()),

		  Folder::folder("system_templates",
			  	owner.iconClass().defaultName(),
				param_.beautifiedName(),false)
	
	);
}

IconHelp::~IconHelp()
{
}

bool IconHelp::fill(int pass)
{
	Folder* system = Folder::folder("system_templates",
					owner_.iconClass().defaultName(),
					param_.beautifiedName(),
					false);

	Request     i = param_.interfaceRequest();
	MvRequest   p = i("help_definition");
	const char* n = i("help_name");

	switch(pass)
	{
		case 0:
			// Try system 
			SyncFolders::sync(folder_,system);
			return true;

		case 1:
			// Copy help
			if(p) {
				IconObject* o = IconFactory::create(folder_,p);
				if(n) o->rename(n);
			}
			return true;

		default:
			return false;
	}
	
}

Widget IconHelp::menu() 
{
	return current_.size() ? menu1_ : menu2_;
}

bool IconHelp::accept(IconObject* o) 
{       
	const IconClass& ic = o->iconClass();
	Request interface = param_.interfaceRequest();
	for ( vector<string>::iterator j =  classes_.begin(); j != classes_.end(); ++j)
		if ( ic.canBecome(IconClass::find(*j)) )   return true;
	return classes_.size() == 0;
}


void IconHelp::deleteCB(Widget, XtPointer)
{
	for(vector<IconObjectH>::iterator j = current_.begin(); 
		j != current_.end(); ++j)
			(*j)->toWastebasket();
}

void IconHelp::editCB(Widget, XtPointer)
{
	for(vector<IconObjectH>::iterator j = current_.begin(); 
		j != current_.end(); ++j)
			(*j)->edit();
}

void IconHelp::folderCB( Widget, XtPointer) 
{
	folder_->open();
}

void IconHelp::newIconCB( Widget, XtPointer )
{
	newIcon();
}


static HelpMaker<IconHelp> maker("help_data");
