/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;

public class SymbolTable
extends Hashtable {
    private static final long serialVersionUID = 1127787896437151144L;
    private VariableFactory vf;
    protected StObservable obeservable = new StObservable();

    public SymbolTable(VariableFactory varFac) {
        this.vf = varFac;
    }

    private SymbolTable() {
    }

    public Object get(Object key) {
        return this.getValue(key);
    }

    public Object getValue(Object key) {
        Variable var = (Variable)super.get(key);
        if (var == null) {
            return null;
        }
        return var.getValue();
    }

    public Variable getVar(String name) {
        return (Variable)super.get(name);
    }

    public Object put(Object key, Object val) {
        return this.makeVarIfNeeded((String)key, val);
    }

    public void setVarValue(String name, Object val) {
        Variable var = (Variable)super.get(name);
        if (var != null) {
            var.setValue(val);
            return;
        }
        throw new NullPointerException("Variable " + name + " does not exist.");
    }

    protected Variable createVariable(String name, Object val) {
        Variable var = this.vf.createVariable(name, val);
        this.obeservable.stSetChanged();
        this.obeservable.notifyObservers(var);
        return var;
    }

    protected Variable createVariable(String name) {
        Variable var = this.vf.createVariable(name);
        this.obeservable.stSetChanged();
        this.obeservable.notifyObservers(var);
        return var;
    }

    public Variable addVariable(String name, Object val) {
        Variable var = (Variable)super.get(name);
        if (var != null) {
            throw new IllegalStateException("Variable " + name + " already exists.");
        }
        var = this.createVariable(name, val);
        super.put(name, var);
        var.setValidValue(true);
        return var;
    }

    public Variable addConstant(String name, Object val) {
        Variable var = this.addVariable(name, val);
        var.setIsConstant(true);
        return var;
    }

    public Variable makeVarIfNeeded(String name, Object val) {
        Variable var = (Variable)super.get(name);
        if (var != null) {
            if (var.isConstant()) {
                throw new IllegalStateException("Attempt to change the value of constant variable " + name);
            }
            var.setValue(val);
            return var;
        }
        var = this.createVariable(name, val);
        super.put(name, var);
        return var;
    }

    public Variable makeVarIfNeeded(String name) {
        Variable var = (Variable)super.get(name);
        if (var != null) {
            return var;
        }
        var = this.createVariable(name);
        super.put(name, var);
        return var;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Variable var = (Variable)e.nextElement();
            sb.append(var.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void clearValues() {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Variable var = (Variable)e.nextElement();
            var.setValidValue(false);
        }
    }

    public VariableFactory getVariableFactory() {
        return this.vf;
    }

    public synchronized void addObserver(Observer arg) {
        this.obeservable.addObserver(arg);
    }

    public synchronized int countObservers() {
        return this.obeservable.countObservers();
    }

    public synchronized void deleteObserver(Observer arg) {
        this.obeservable.deleteObserver(arg);
    }

    public synchronized void deleteObservers() {
        this.obeservable.deleteObservers();
    }

    public synchronized boolean hasChanged() {
        return this.obeservable.hasChanged();
    }

    public synchronized void addObserverToExistingVariables(Observer arg) {
        Enumeration en = this.elements();
        while (en.hasMoreElements()) {
            Variable var = (Variable)en.nextElement();
            var.addObserver(arg);
        }
    }

    public void clearNonConstants() {
        Variable var;
        Vector<Variable> tmp = new Vector<Variable>();
        Enumeration<Object> en = this.elements();
        while (en.hasMoreElements()) {
            var = (Variable)en.nextElement();
            if (!var.isConstant()) continue;
            tmp.add(var);
        }
        this.clear();
        en = tmp.elements();
        while (en.hasMoreElements()) {
            var = (Variable)en.nextElement();
            super.put(var.getName(), var);
        }
    }

    public class StObservable
    extends Observable {
        protected synchronized void stSetChanged() {
            this.setChanged();
        }

        public SymbolTable getSymbolTable() {
            return SymbolTable.this;
        }
    }
}

