/*
 * Copyright (C) 2017 Konstantin Tokarev <annulen@yandex.ru>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <wchar.h>
#include <wtf/text/WTFString.h>

namespace WTF {

inline Vector<wchar_t> stringToNullTerminatedWChar(const String& string)
{
    Vector<wchar_t> result;

    if (!string.isNull()) {
        result.reserveInitialCapacity(string.impl()->length() + 1);

        if (string.is8Bit()) {
            const LChar* characters8 = string.impl()->characters8();
            for (size_t i = 0; i < string.impl()->length(); ++i)
                result.uncheckedAppend(characters8[i]);
        } else {
            const UChar* characters16 = string.impl()->characters16();
            result.append(characters16, string.impl()->length());
        }

        result.append(0);
    }

    return result;
}

inline String wcharToString(const wchar_t* characters, unsigned length)
{
    static_assert(sizeof(wchar_t) == sizeof(UChar), "We assume wchar_t and UChar have the same size");
    return String(reinterpret_cast<const UChar*>(characters), length);
}

inline String nullTerminatedWCharToString(const wchar_t* characters)
{
    return wcharToString(characters, wcslen(characters));
}

} // namespace WTF

using WTF::stringToNullTerminatedWChar;
using WTF::wcharToString;
using WTF::nullTerminatedWCharToString;
