#ifndef PHYTON_PRG_HPP
#define PHYTON_PRG_HPP

#include "scripting.hpp"
#include "scriptprg.hpp"

#include <Python.h>

/**
enables python for scripting games logic

	@author Harald Krippel <harald@the-develop.net>
*/

class PythonEnv : public QObject
{
//	Q_OBJECT
public:

  static PythonEnv *theInstance(QObject *parent=0);
  PyObject *main_module;
  PyObject *main_dict;

   PythonEnv (QObject *parent=0);
   ~PythonEnv ();
   void Init ();

private:

   static PythonEnv *theInstancePtr;
};


class python_prg : public scriptPrg
{
public:
    python_prg(const QString & program, const int thisid);
    ~python_prg();

    int compile(void);
    int run(void);
    void update(void);
    static PyObject* setCallback( PyObject* self, PyObject* args );

private:
   static QHash<int, PyObject *> pythonCallbackList;

protected:
    int runFile(const QString &prgfile);
    bool handleError();

    QcakeScriptApi *ScriptApi;
    QString  prgname;
    PyObject *pMainModule;
    PyObject *main_dict_copy;
    int qcid;
};

#endif
