/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef PLUGIN_H
#define PLUGIN_H

#include <QString>
#include <QList>
#include <QPluginLoader>

class QChatBasicPlugin;
class QChatWidgetPlugin;

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class Plugin
{
  public:
    enum PluginType{Basic, Widget};

  private:
    QString m_path;
    QString m_name;
    QPluginLoader* m_plugin;
    PluginType m_type;

    bool m_isLoaded;

  public:
    Plugin();
    ~Plugin();

    void setPath(const QString& path){m_path = path;}
    const QString& path() const {return m_path;}

    void setName(const QString& name){m_name = name;}
    const QString& name() const {return m_name;}

    QPluginLoader* plugin(){return m_plugin;}
    void setPlugin(QPluginLoader* plug){m_plugin = plug;}

    void setType(PluginType theValue){m_type = theValue;}
    PluginType type() const {return m_type;}

    bool isLoaded(){return m_isLoaded;}

    bool load();
    bool unload();

    QObject*           instance();
    QChatBasicPlugin*  instanceBasic();
    QChatWidgetPlugin* instanceWgt();
};

#endif
