/*
 *      videoCapture.h -- Kapture
 *
 *      Copyright (C) 2006-2007
 *          Detlev Casanova (detlev.casanova@gmail.com)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 */

#ifndef _VIDEOCAPTURE_H
#define _VIDEOCAPTURE_H

#include <QObject>
#include <QImage>
#include <linux/videodev2.h>

struct tableFormat
{
  QString description;
  unsigned int val1;
  unsigned int val2;
};
extern tableFormat sizeList[];
extern tableFormat fpsList[];

enum ecamSize{PICMAX,PICMIN,PICHALF};

class videoCapture : public QObject
{
	Q_OBJECT

public:
  videoCapture();
  ~videoCapture();
	
	void close();
  bool  open();
	QList<int>   getFormatList(QList<QString> &description) const;
	QList<QSize> getSizesList() const;
  QList<int> formatList;
  QList<QSize> sizeList;
  QList<QString> descripList;

  bool setFormat(unsigned int width, unsigned int height, int pixelformat=V4L2_PIX_FMT_MJPEG);
  bool getFormat();
  bool getFrame();
	int currentWidth() const;
	int currentHeight() const;
	int currentPixelFormat() const;
	int changeCtrl(int ctrl, int value = 0);
	int defaultCtrlVal(unsigned int control, int &defaultValue);
  bool isOpened() const {return opened;};
  bool takeSnapshot();
  QImage *getImage() {return localImage;}
  bool captureStart();
  bool captureStop();
  bool stopStreaming();
  bool startSnapshots();
  void abortCapture() { abortCap=TRUE;}


  enum econtrol {Saturation = 0,Hue,Brightness,Contrast,Sharpness};
signals:
  void imageReady();
	

private:
	int dev;
	v4l2_format fmt;
	v4l2_buffer buf;
	v4l2_requestbuffers rb;
	bool allocated;
	
  uchar *mem[4];
	size_t bufLength;
  QImage *localImage;
	bool opened;
	bool mmaped;
  void YUV422toRGB888_ITU_R( unsigned char *src,int width, int height);
  void YUV422toRGB888_NTSC( unsigned char *src,int width, int height);
  bool streaming;
  void dumpCaps(v4l2_capability &cap);
  int numBuffers;
  bool abortCap;
};
#endif

