/*
 * Created on Apr 20, 2005
 */
package edu.uoregon.tau.taujava.popup.actions;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Pattern;

//import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import edu.uoregon.tau.taujava.TaujavaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class InstrumentJava implements IObjectActionDelegate {

	//These vectors contain names of files and methods to include and exclude, respectively
	private Vector fileEx;
	private Vector fileIn;
	private Vector nameEx;
	private Vector nameIn;
	
	/*This method obtains the location of the exclusion document from the preferences
	 * store and parses it for the names to be included or excluded from instrumentation
	 * which are stored in the vectors defined above for later reference*/
	private void exclusionSetup(){
		fileEx = new Vector();
		fileIn = new Vector();
		nameEx = new Vector();
		nameIn = new Vector();
		
		IPreferenceStore pstore = TaujavaPlugin.getDefault().getPreferenceStore();
		String result = pstore.getString("exclusionPathPreference") ;
		if(result==null)result="";
		if(result=="" || !pstore.getBoolean("exclusionPreference"))return;
		try {
			BufferedReader in = new BufferedReader(new FileReader(result));

			String aline = "";
			while((aline=in.readLine()) != null){
				if(aline.length()==0 || aline.charAt(0) == '#'){continue;}
				
				if(aline.equals("BEGIN_EXCLUDE_LIST"))
				{
					while((aline=in.readLine()) != null)
					{
						if(aline.equals("END_EXCLUDE_LIST")){break;}
						if(aline.length()==0 || aline.charAt(0) == '#'){continue;}
						nameEx.add(aline);
					}
					if(aline==null)return;
				}
				if(aline.equals("BEGIN_INCLUDE_LIST"))
				{
					while((aline=in.readLine()) != null)
					{
						if(aline.equals("END_INCLUDE_LIST")){break;}
						if(aline.length()==0 || aline.charAt(0) == '#'){continue;}
						nameIn.add(aline);
					}
					if(aline==null)return;
				}
				if(aline.equals("BEGIN_FILE_EXCLUDE_LIST"))
				{
					while((aline=in.readLine()) != null)
					{
						if(aline.equals("END_FILE_EXCLUDE_LIST")){break;}
						if(aline.length()==0 || aline.charAt(0) == '#'){continue;}
						fileEx.add(aline);
					}
					if(aline==null)return;
				}
				if(aline.equals("BEGIN_FILE_INCLUDE_LIST"))
				{
					while((aline=in.readLine()) != null)
					{
						if(aline.equals("END_FILE_INCLUDE_LIST")){break;}
						if(aline.length()==0 || aline.charAt(0) == '#'){continue;}
						//System.out.println(aline);
						fileIn.add(aline);
					}
					if(aline==null)return;
				}
			}
			
			in.close();
			} catch (FileNotFoundException e) {
				// TOD Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TOD Auto-generated catch block
				e.printStackTrace();
			}
		}
	
	/**
	 * Constructor for Action1.
	 */
	public InstrumentJava() {
		super();
		return;
	}

	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	IStructuredSelection selection;

	/**
	 * @throws JavaModelException 
	 * @see IActionDelegate#run(IAction)
	 */
	
	public int classPathSetup(IJavaElement element) throws JavaModelException{
		IPreferenceStore pstore = TaujavaPlugin.getDefault().getPreferenceStore();
		String path = pstore.getString("tauDirPathPreference") ;
		if(path==null)path="";
		if(path.equals(""))return 1;
		path+="/TAU.jar";
		//System.out.println(path);
		
		IJavaProject javaProj = element.getJavaProject();
		
		
		
		Path cp = new Path(path);
		
		if(!cp.toFile().exists())
		{
			return 1;
		}
		
		/*IFile taujar = javaProj.getUnderlyingResource().getWorkspace().getRoot().getFileForLocation(cp);//IWorkspaceRoot.getFileForLocation(cp);
		
		if(taujar==null || javaProj.isOnClasspath(taujar))
		{	System.out.println("Found!");
			return;
		}*/
		
		IClasspathEntry cpe= JavaCore.newLibraryEntry(cp, null, null);
		
		IClasspathEntry[] oldpath = javaProj.getRawClasspath();
		
		for(int i=0; i<oldpath.length;i++)
		{
			if(oldpath[i].getPath().toString().equals(cpe.getPath().toString()))
			{
				//System.out.println("Found It! "+cpe.getPath().toString());
				return 0;
			}
		}
		
		IClasspathEntry[] newpath;
		
		if(oldpath==null)
		{
			newpath = new IClasspathEntry[] {cpe};
		}
		else
		{
			newpath = new IClasspathEntry[oldpath.length+1];
			System.arraycopy(oldpath,0,newpath,0, oldpath.length);
			newpath[newpath.length-1]=cpe;
		}
		
		javaProj.setRawClasspath(newpath, null);
		return 0;
		//proj.
	}
	
	public void run(IAction action) {
		if (selection == null)
			return;
		try {
			/*
			 * Get the selected element, check and convert to the proper element
			 * type Transmit to the correct processing method.
			 */
			
			

			exclusionSetup();
			
			
			IJavaElement element = (IJavaElement) selection.getFirstElement();
			
			if(classPathSetup(element)!=0)
			{
				Shell shell = new Shell();
				MessageDialog.openInformation(
					shell,
					"Taujava Plug-in",
					"TAU.jar not found.  Please select a viable tau library directory.  Instrumentation aborted.");
				return;
			}
			
			//element.getResource().getWorkspace()
			
			if (element.getElementType() == IJavaElement.JAVA_PROJECT) {
				IJavaProject jproject = (IJavaProject) element;
				instrumentProject(jproject);
			} else {
				if (element.getElementType() == IJavaElement.PACKAGE_FRAGMENT) {
					IPackageFragment jfragment = (IPackageFragment) element;
					instrumentPackage(jfragment);
				} else {
					if (element.getElementType() == IJavaElement.COMPILATION_UNIT) {
						ICompilationUnit jfile = (ICompilationUnit) element;
						instrumentJava(jfile);
					}
				}
			}

		} catch (JavaModelException e) {
			e.printStackTrace();
		} catch (MalformedTreeException e) {
			e.printStackTrace();
		} catch (BadLocationException e) {
			e.printStackTrace();
		} catch (ClassCastException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void instrumentProject(IJavaProject jproject)
			throws JavaModelException, MalformedTreeException, BadLocationException, IOException {
		/*
		 *  Run the package instrumenter on each package in the project
		 */

		IPackageFragment[] fragments = jproject.getPackageFragments();
		for (int i = 0; i < fragments.length; i++) {
			instrumentPackage(fragments[i]);
		}

		/*
		 * IPackageFragmentRoot[] froots = jproject.getPackageFragmentRoots();
		 * for(int i = 0; i <froots.length;i++) { for(int j =0; j
		 * <froots[i].getPackage) }
		 */
	}

	
	/*This function compares the String test with every element of the vector
	 * elements, where the vector elements may have wildcard characters*/
	public boolean wildSeek(String test,Vector elements,String wildcard){
		String regExHold;
		System.out.println("Checking: "+test+" with wild: "+wildcard);
		for(int i=0;i<elements.size();i++){
			regExHold=((String)elements.get(i));
			regExHold=regExHold.trim();
			System.out.println("Against: "+regExHold);
			if(!wildcard.equals("*"))
				regExHold=regExHold.replaceAll("\\*","\\\\*");
			regExHold=regExHold.replaceAll("\\.","\\\\.");
			
			if(wildcard.equals("*"))
			{
				regExHold=regExHold.replaceAll("\\*",".*");
			}
			else
			{
				regExHold=regExHold.replaceAll(wildcard,".*");
			}
			regExHold=regExHold.replaceAll("\\(","\\\\(");
			regExHold=regExHold.replaceAll("\\)","\\\\)");
			regExHold=regExHold.replaceAll("\\[","\\\\[");
			regExHold=regExHold.replaceAll("\\]","\\\\]");
			System.out.println(regExHold);
			if(Pattern.matches(regExHold,test)){
				//System.out.println("Matched");
				return true;
			}
		}
		//System.out.println("Not Matched");
		return false;
	}
	
	/*For each java file in the package that is not excluded (or is included) run the 
	 * java instrumenter*/
	public void instrumentPackage(IPackageFragment jfragment)
			throws JavaModelException, MalformedTreeException, BadLocationException {
		ICompilationUnit[] compunits = jfragment.getCompilationUnits();
		
		Vector use = new Vector();
		if(fileEx.size()>0){
			//System.out.println("esize="+fileEx.size());
			for(int i=0;i<compunits.length;i++){
				//if(!fileEx.)
				if(!wildSeek(compunits[i].getElementName(),fileEx,"*")){//!fileEx.contains(compunits[i].getElementName()) || 
					use.add(compunits[i]);
				}
			}
			compunits = (ICompilationUnit[]) use.toArray(compunits);
		}
		else
		if(fileIn.size()>0){
			//System.out.println("isize="+fileIn.size());
			for(int i=0;i<compunits.length;i++){
				if(wildSeek(compunits[i].getElementName(),fileIn,"*")){//fileIn.contains((Object)compunits[i].getElementName()) || 
					use.add(compunits[i]);
					//System.out.println(compunits[i].getElementName());
					}
			}
			compunits = (ICompilationUnit[]) use.toArray(compunits);
		}
		
		for (int i = 0; i < compunits.length; i++) {
			if(compunits[i]==null)break;
			instrumentJava(compunits[i]);
		}
	}
	
	private String source;
	private ICompilationUnit carrier;

	/*Obtain the java file, instrument each class it contains and resave the file*/
	public void instrumentJava(ICompilationUnit jfile) throws JavaModelException{
		
		ICompilationUnit workingjfile = jfile.getWorkingCopy(null);
		IType[] types = workingjfile.getTypes();
		
		String pack = "";
		IPackageDeclaration[] packs = workingjfile.getPackageDeclarations();
		if(packs.length != 0)
			pack=packs[0].getElementName();
		//System.out.println(pack);
		String name = workingjfile.getElementName();
		//int period=name.lastIndexOf('.');
		name = name.substring(0,name.lastIndexOf('.'));
		
		String idname = name;
		if(pack != null)
		idname = pack+"."+name;
		//System.out.println("ENTERING FILE: " + idname);
		
		int numtypes=types.length;
		source = workingjfile.getBuffer().getContents();
		carrier=workingjfile;
		//carrier.getBuffer().setContents(source);
		//ICompilationUnit holder = new ICompilationUnit();
		int typedex=0;
		for(int i =0; i<numtypes;i++){
			//System.out.println(types[i].getElementName() + numtypes);
			if(types[i].isClass() && !types[i].isAnonymous()){
				instrumentClass(types[i],name,idname,0,typedex);
				typedex++;
				types = carrier.getTypes();
			}
		}
		//workingjfile.save(null,true);
		//workingjfile.getBuffer().setContents(source);
		workingjfile.commitWorkingCopy(true,null);
		jfile.save(null,true);
		//workingjfile.discardWorkingCopy();
		
	}

	/*
	 * 
	 * Add a single array containing the tau-instrumenter entities for each included method in 
	 * this class and instrument each included class and method 
	 * 
	 * */
	public void instrumentClass(IType type, 
			String finame, String idname, int depth,int order) throws JavaModelException{
		
		//Get the internal types contained in this type
		IType[] types = type.getTypes();
		
		//Recursively construct the names of the methods (. and _ delineated)
		String usename=finame+"_"+type.getElementName();
		String useidname=idname+"."+type.getElementName();
		
		//Recursively instrument internal classes
		int numtypes=types.length;
		int typedex=0;
		for (int i = 0; i < numtypes; i++) {
			if(types[i].isClass() && !types[i].isAnonymous()){
				instrumentClass(types[i], usename,useidname,depth+1,typedex);
				type=carrier.getType(type.getElementName());
				types = type.getTypes();
				typedex++;
			}
		}
		
		
		Vector rootline = new Vector();
		int openbrack=0;
		if(depth==0)
		{
			//type.createField(tauinit,null,true,null);
			
			int start = type.getSourceRange().getOffset();
			//int end = start+type.getSourceRange().getLength();
			openbrack = indexSansComments(source,"{",start);
			
			//System.out.println(type.getElementName()+" setup at "+depth+" from "+start+" at "+openbrack);
		}
		else
		{	//Maintained for activitity equality!
			IType rooter = type;
			rootline.add(0,rooter.getElementName());
			for(int i = depth; i>0; i--)
			{
				rooter = (IType) rooter.getParent();
				rootline.add(0,rooter.getElementName());
			}
			//rooter.createField(tauinit,null,true,null);
			int start = rooter.getSourceRange().getOffset();
			openbrack = indexSansComments(source,"{",start);
			
			//System.out.println(source);
			//System.out.println(type.getElementName()+" setup at "+depth);
		}
		
		
		IMethod[] methods = type.getMethods();
		int nummeths = methods.length;
		int mdex=0;
		//System.out.println(type.getElementName()+" build at "+depth);
		String tauinit = "\n/*TAU_INSTRUMENTATION - Do not edit between these comments.*/  static TAU.Profile[] " + usename+"Profiles = {";
		
		String methdef = "";
		
		for(int i=0;i<nummeths;i++){	
			
			methdef = Signature.toString(methods[i].getReturnType())+" "+ 
			useidname + "." + methods[i].getElementName().toString()+ "(";
			String[] parn = methods[i].getParameterNames();
			String[] part = methods[i].getParameterTypes();
			for(int j = 0;j<parn.length;j++){
				if(j>0)methdef+=", ";
				methdef+=Signature.toString(part[j])+" "+parn[j];
			}
			methdef+=")";
			
			if((nameIn.size()==0&&nameEx.size()==0)
				||(nameIn.size()>0&&wildSeek(methdef,nameIn,"#"))
				||(nameEx.size()>0&&!wildSeek(methdef,nameEx,"#"))){//methods[i].getElementName().toString()

				instrumentMethod(methods[i], usename,mdex);
				if(rootline.size()>0){
					type=carrier.getType((String)rootline.firstElement());
					for(int j=1;j<rootline.size();j++)
					{
						type=type.getType((String)rootline.get(j));
					}
				}
				else
					type=carrier.getType(type.getElementName());

				methods=type.getMethods();
			
				if(mdex>0)tauinit+=",";
				tauinit+=" new TAU.Profile(\""+methdef;
				tauinit+="\", \"\", \"TAU_DEFAULT\", TAU.Profile.TAU_DEFAULT)";
				mdex++;
			}	
		}
		
		tauinit+="};/*TAU_INSTRUMENTATION - Do not edit between these comments.*/\n";
	
		source = source.substring(0,openbrack+1)+tauinit+source.substring(openbrack+1);
		carrier.getBuffer().setContents(source);
		carrier.makeConsistent(null);
	}

	
	/*
	 * 
	 * Insert the contents of the method into a try block that starts with the 'tau start' call.
	 * Add a finally block to generate the 'tau stop' call.
	 * 
	 * */
	public void instrumentMethod(IMethod method, String type, int order) throws JavaModelException{
		//System.out.println("In method instrumenter...");
		String msource = method.getSource();
		
		String tryadd = "\n/*TAU_INSTRUMENTATION - Do not edit between these comments.*/try{"+type+"Profiles["+order+"].Start();/*TAU_INSTRUMENTATION - Do not edit between these comments.*/\n";
		
		int openbrack=indexSansComments(msource,"{",0); //source.indexOf('{');
		if(openbrack==-1){
			//System.out.println("Empty Method?\n"+msource);
			return;
		}
		
		if(method.isConstructor()){
			int fstsmc = indexSansComments(msource,";",openbrack);
			if(fstsmc == -1)return;
			String clip = msource.substring(openbrack,fstsmc);
			int dexmod = 0;
			int condex = indexSansComments(clip,"super",0);
			if(condex!=-1)dexmod=5;
			else{
				condex = indexSansComments(clip,"this",0);
				dexmod=4;
			}
			
			if(condex != -1){
				int oparen = clip.indexOf('(',condex);
				if(oparen!=-1){
					//System.out.println(condex+dexmod+"-"+oparen+" "+clip.substring(condex+dexmod,oparen));
					if(clip.substring(condex+dexmod,oparen).trim().length()==0)openbrack=fstsmc;
				}
			}
		}
		//System.out.println("Original Source:\n"+msource);
		msource = msource.substring(0,openbrack+1)+tryadd+msource.substring(openbrack+1);
		//System.out.println("Turned to:\n"+msource);
		int closebrack = msource.lastIndexOf('}');//lastIndexSansComments(source,"}",source.length());//
		if(closebrack<0)
		{
			System.out.println("BUG!");
			System.out.println(msource);
			return;
		
		}
		
		String finadd = "\n/*TAU_INSTRUMENTATION - Do not edit between these comments.*/}"+"finally{"+type+"Profiles["+order+"].Stop();}/*TAU_INSTRUMENTATION - Do not edit between these comments.*/\n";
		
		msource = msource.substring(0,closebrack)+finadd+msource.substring(closebrack);
		//System.out.println("Reconstructed method");
		int mstart = method.getSourceRange().getOffset();
		int mend = mstart+method.getSourceRange().getLength();//+tryadd.length()+finadd.length();
		source=source.substring(0,mstart)+msource+source.substring(mend);
		//System.out.println("Replacing: \n"+source.substring(mstart,mend)+" with: \n"+ msource);
		carrier.getBuffer().setContents(source);
		carrier.makeConsistent(null);
	}

	/*
	private boolean inDoubQuote(String input, int index){
		int quocount = 0;
		int lastquo = input.lastIndexOf("\"",index);
		if(lastquo ==-1)return false;
		
		while(lastquo != -1)
		{	quocount++;
			lastquo=input.lastIndexOf("\"",lastquo-1);
		}
		return(quocount%2!=0);
		
	}
	
	private boolean inSingQuote(String input, int index){
		int quocount = 0;
		int lastquo = input.lastIndexOf("\'",index);
		if(lastquo ==-1)return false;
		
		while(lastquo != -1)
		{	quocount++;
			lastquo=input.lastIndexOf("\'",lastquo-1);
		}
		return(quocount%2!=0);
		
	}*/
	
	private boolean inLineCom(String input, int index){
		int lastret = input.lastIndexOf('\n',index);
		int lastcom = input.lastIndexOf("//",index);
		if(lastcom == -1)return false;
		return(lastret<lastcom);
	}
	
	private boolean inBlockCom(String input, int index){
		int lastend = input.lastIndexOf("*/",index);
		int lastcom = input.lastIndexOf("/*",index);
		if(lastcom == -1)return false;
		while(inLineCom(input,lastcom)){
			//System.out.println("BlockLoop: "+lastcom);
			lastcom = input.lastIndexOf("/*",lastcom-1);
			if(lastcom == -1)return false;
		}
		
		return(lastend<lastcom);
	}
	
	private int indexSansComments(String input,String find, int startdex){
		int seeker = input.indexOf(find,startdex);
		if(seeker==-1)return seeker;
		//System.out.println(find+" at "+ seeker);
		while(inLineCom(input,seeker)||inBlockCom(input,seeker)){//||inDoubQuote(input,seeker)||inSingQuote(input,seeker)){
			//System.out.println("SansLoop: "+seeker);
			seeker=input.indexOf(find,seeker+1);
			//System.out.println(find+" at "+ seeker);
			if(seeker==-1)return seeker;
		}
		return seeker;

	}
	/*
	private int lastIndexSansComments(String input,String find, int startdex){
		int seeker = input.lastIndexOf(find,startdex);
		if(seeker==-1)return seeker;
		while(inLineCom(input,seeker)||inBlockCom(input,seeker)){
			seeker=input.lastIndexOf(find,seeker);
			if(seeker==-1)return seeker;
		}
		return seeker;
	}*/
	
	
	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection)
			this.selection = (IStructuredSelection) selection;
		else
			this.selection = null;
	}
}