/*	------------------------------------------------------------	*/

/*	############################################################
	# @(#) ansi_raw.h
	# @(#)
	# @(#) Copyright (c) 1995-2001 by Dirk Hagedorn
	# @(#) Dirk Hagedorn (udo@dirk-hagedorn.de)
	#
	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.
	# 
	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.
	# 
	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	# 
	#
	#
	# ANSI-Zeichensatz in ASCII-Zeichensatz umsetzen
	# die Tabelle wird auch fuer WinHelp benutzt, dort von
	# ASCII nach ANSI, deshalb duerfen hier keine ASCII-Werte
	# < 128 (\200) vorkommen!
	############################################################	*/

#define	MAXANSI2ASC	72
typedef struct _a2aitem
{	unsigned char	ansi;
	unsigned char	ascii;
}	A2AITEM;

const A2AITEM a2aitem[MAXANSI2ASC]=
{
	{	'\200',	'\'		},		/* null		*/
	{	'\201',	'\'		},		/* null		*/
	{	'\202',	'\'		},		/* '' (9u)	*/
	{	'\203',	'\'		},		/* #f		*/
	{	'\204',	'\'		},		/* "" (99u)	*/
	{	'\205',	'\'		},		/* !..		*/
	{	'\206',	'\'		},		/* #dag		*/
	{	'\207',	'\'		},		/* 2x#dag	*/
	{	'\210',	'\'		},		/* #circ	*/
	{	'\211',	'\'		},		/* #promill	*/
	{	'\212',	'\'		},		/* vS		*/
	{	'\213',	'\'		},		/* <		*/
	{	'\214',	'\'		},		/* &OE		*/
	{	'\215',	'\'		},		/* null		*/
	{	'\216',	'\'		},		/* null		*/
	{	'\217',	'\'		},		/* null		*/
	{	'\220',	'\'		},		/* null		*/
	{	'\221',	'\'		},		/* '' (6o)	*/
	{	'\222',	'\'		},		/* '' (9o)	*/
	{	'\223',	'\'		},		/* "" (66o)	*/
	{	'\224',	'\'		},		/* "" (99u)	*/
	{	'\225',	'\'		},		/* #bullet	*/
	{	'\226',	'\'		},		/* --		*/
	{	'\227',	'\'		},		/* ---		*/
	{	'\230',	'\'		},		/* !~		*/
	{	'\231',	'\'		},		/* #tm		*/
	{	'\232',	'\'		},		/* vs		*/
	{	'\233',	'\'		},		/* >		*/
	{	'\234',	'\'		},		/* &oe		*/
	{	'\235',	'\'		},		/* null		*/
	{	'\236',	'\'		},		/* null		*/
	{	'\237',	'\'		},		/* "Y		*/
	{	'\240',	'\'		},		/* null		*/
	{	'\241',	'\'		},		/* #!		*/
	{	'\242',	'\'		},		/* #cent	*/
	{	'\243',	'\'		},		/* #pound	*/
	{	'\244',	'\'		},		/* general currency	*/
	{	'\245',	'\'		},		/* #yen		*/
	{	'\246',	'\'		},		/* broken dash	*/
	{	'\247',	'\'		},		/* #sect	*/
	{	'\250',	'\'		},		/* #"		*/
	{	'\251',	'\'		},		/* #copy	*/
	{	'\252',	'\'		},		/* _a		*/
	{	'\253',	'\'		},		/* #<		*/
	{	'\254',	'\'		},		/* #neg		*/
	{	'\255',	'\'		},		/* strich	*/
	{	'\256',	'\'		},		/* #reg		*/
	{	'\257',	'\'		},		/* upline	*/
	{	'\260',	'\'		},		/* #degree	*/
	{	'\261',	'\'		},		/* #pm		*/
	{	'\262',	'\'		},		/* #^2		*/
	{	'\263',	'\'		},		/* #^3		*/
	{	'\264',	'\'		},		/* #'		*/
	{	'\265',	'\'		},		/* #mu		*/
	{	'\266',	'\'		},		/* #p		*/
	{	'\267',	'\'		},		/* #cdot	*/
	{	'\270',	'\'		},		/* cedille	*/
	{	'\271',	'\'		},		/* #^1		*/
	{	'\272',	'\'		},		/* _o		*/
	{	'\273',	'\'		},		/* #>		*/
	{	'\274',	'\'		},		/* #1/4		*/
	{	'\275',	'\'		},		/* #1/2		*/
	{	'\276',	'\'		},		/* #3/4		*/
	{	'\277',	'\'		},		/* #?		*/
	{	'\300',	'\'		},		/* `A		*/
	{	'\301',	'\'		},		/* 'A		*/
	{	'\302',	'\'		},		/* ^A		*/
	{	'\303',	'\'		},		/* ~A		*/
	{	'\304',	'\'		},		/* "A		*/
	{	'\305',	'\'		},		/* .A		*/
	{	'\306',	'\'		},		/* &AE		*/
	{	'\307',	'\'		},		/* ,C		*/
	{	'\310',	'\'		},		/* `E		*/
	{	'\311',	'\'		},		/* 'E		*/
	{	'\312',	'\'		},		/* ^E		*/
	{	'\313',	'\'		},		/* "E		*/
	{	'\314',	'\'		},		/* `I		*/
	{	'\315',	'\'		},		/* 'I		*/
	{	'\316',	'\'		},		/* ^I		*/
	{	'\317',	'\'		},		/* "I		*/
	{	'\320',	'\'		},		/* -D		*/
	{	'\321',	'\'		},		/* ~N		*/
	{	'\322',	'\'		},		/* `O		*/
	{	'\323',	'\'		},		/* 'O		*/
	{	'\324',	'\'		},		/* ^O		*/
	{	'\325',	'\'		},		/* ~O		*/
	{	'\326',	'\'		},		/* "O		*/
	{	'\327',	'\'		},		/* #times	*/
	{	'\330',	'\'		},		/* /O		*/
	{	'\331',	'\'		},		/* `U		*/
	{	'\332',	'\'		},		/* 'U		*/
	{	'\333',	'\'		},		/* ^U		*/
	{	'\334', '\'		},		/* "U		*/
	{	'\335',	'\'		},		/* 'Y		*/
	{	'\336',	'\'		},		/* |b		*/
	{	'\337', '\'		},		/* "s		*/
	{	'\340',	'\'		},		/* `a		*/
	{	'\341',	'\'		},		/* 'a		*/
	{	'\342',	'\'		},		/* ^a		*/
	{	'\343',	'\'		},		/* ~a		*/
	{	'\344', '\'		},		/* "a		*/
	{	'\345',	'\'		},		/* .a		*/
	{	'\346',	'\'		},		/* &ae		*/
	{	'\347',	'\'		},		/* ,c		*/
	{	'\350',	'\'		},		/* `e		*/
	{	'\351',	'\'		},		/* 'e		*/
	{	'\352',	'\'		},		/* ^e		*/
	{	'\353',	'\'		},		/* "e		*/
	{	'\354',	'\'		},		/* `i		*/
	{	'\355',	'\'		},		/* 'i		*/
	{	'\356',	'\'		},		/* ^i		*/
	{	'\357',	'\'		},		/* "i		*/
	{	'\360',	'\'		},		/* o|''		*/
	{	'\361',	'\'		},		/* ~n		*/
	{	'\362',	'\'		},		/* `o		*/
	{	'\363',	'\'		},		/* 'o		*/
	{	'\364',	'\'		},		/* ^o		*/
	{	'\365',	'\'		},		/* ~o		*/
	{	'\366', '\'		},		/* "o		*/
	{	'\367',	'\'		},		/* #div		*/
	{	'\370',	'\'		},		/* /o		*/
	{	'\371',	'\'		},		/* `u		*/
	{	'\372',	'\'		},		/* 'u		*/
	{	'\373',	'\'		},		/* ^u		*/
	{	'\374', '\'		},		/* "u		*/
	{	'\375',	'\'		},		/* 'y		*/
	{	'\376',	'\'		},		/* |B		*/
	{	'\377',	'\'		}		/* "y		*/
};
