/* valavapigen.c generated by valac, the Vala compiler
 * generated from valavapigen.vala, do not modify */

/* valavapigen.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <valagee.h>
#include <locale.h>
#include <version.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_VAPI_GEN (vala_vapi_gen_get_type ())
#define VALA_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGen))
#define VALA_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))
#define VALA_IS_VAPI_GEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VAPI_GEN))
#define VALA_IS_VAPI_GEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VAPI_GEN))
#define VALA_VAPI_GEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VAPI_GEN, ValaVAPIGenClass))

typedef struct _ValaVAPIGen ValaVAPIGen;
typedef struct _ValaVAPIGenClass ValaVAPIGenClass;
typedef struct _ValaVAPIGenPrivate ValaVAPIGenPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_vapi_gen_unref0(var) ((var == NULL) ? NULL : (var = (vala_vapi_gen_unref (var), NULL)))
typedef struct _ValaParamSpecVAPIGen ValaParamSpecVAPIGen;

struct _ValaVAPIGen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaVAPIGenPrivate * priv;
};

struct _ValaVAPIGenClass {
	GTypeClass parent_class;
	void (*finalize) (ValaVAPIGen *self);
};

struct _ValaVAPIGenPrivate {
	ValaCodeContext* context;
};

struct _ValaParamSpecVAPIGen {
	GParamSpec parent_instance;
};


static gpointer vala_vapi_gen_parent_class = NULL;
static gchar* vala_vapi_gen_directory;
static gchar* vala_vapi_gen_directory = NULL;
static gboolean vala_vapi_gen_version;
static gboolean vala_vapi_gen_version = FALSE;
static gboolean vala_vapi_gen_quiet_mode;
static gboolean vala_vapi_gen_quiet_mode = FALSE;
static gboolean vala_vapi_gen_disable_warnings;
static gboolean vala_vapi_gen_disable_warnings = FALSE;
static gchar** vala_vapi_gen_sources;
static gchar** vala_vapi_gen_sources = NULL;
static gchar** vala_vapi_gen_vapi_directories;
static gchar** vala_vapi_gen_vapi_directories = NULL;
static gchar** vala_vapi_gen_gir_directories;
static gchar** vala_vapi_gen_gir_directories = NULL;
static gchar** vala_vapi_gen_metadata_directories;
static gchar** vala_vapi_gen_metadata_directories = NULL;
static gchar* vala_vapi_gen_library;
static gchar* vala_vapi_gen_library = NULL;
static gchar** vala_vapi_gen_packages;
static gchar** vala_vapi_gen_packages = NULL;
static gboolean vala_vapi_gen_nostdpkg;
static gboolean vala_vapi_gen_nostdpkg = FALSE;

G_GNUC_INTERNAL gpointer vala_vapi_gen_ref (gpointer instance);
G_GNUC_INTERNAL void vala_vapi_gen_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_vapi_gen (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_vapi_gen (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_vapi_gen (GValue* value,
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_vapi_gen (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_vapi_gen_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_VAPI_GEN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_VAPI_GEN, ValaVAPIGenPrivate))
static gint vala_vapi_gen_quit (ValaVAPIGen* self);
static gint vala_vapi_gen_run (ValaVAPIGen* self);
GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
void vala_gidl_parser_parse (ValaGIdlParser* self,
                             ValaCodeContext* context);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      const gchar* needle);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static gint vala_vapi_gen_main (gchar** args,
                         int args_length1);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_new (void);
G_GNUC_INTERNAL ValaVAPIGen* vala_vapi_gen_construct (GType object_type);
static void vala_vapi_gen_finalize (ValaVAPIGen * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_VAPI_GEN_options[12] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_gir_directories, "Look for GIR bindings in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_nostdpkg, "Do not include standard packages", NULL}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_vapi_gen_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_vapi_gen_library, "Library name", "NAME"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_vapi_gen_directory, "Output directory", "DIRECTORY"}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_disable_warnings, "Disable warnings", NULL}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_vapi_gen_version, "Display version number", NULL}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_vapi_gen_quiet_mode, "Do not print messages to the console", NULL}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_vapi_gen_sources, NULL, "FILE..."}, {NULL}};

static gint
vala_vapi_gen_quit (ValaVAPIGen* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaReport* _tmp1_;
	ValaReport* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_report (_tmp0_);
	_tmp2_ = _tmp1_;
	if (vala_report_get_errors (_tmp2_) == 0) {
		gboolean _tmp3_;
		_tmp3_ = vala_vapi_gen_quiet_mode;
		if (!_tmp3_) {
			FILE* _tmp4_;
			ValaCodeContext* _tmp5_;
			ValaReport* _tmp6_;
			ValaReport* _tmp7_;
			_tmp4_ = stdout;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			fprintf (_tmp4_, "Generation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp7_));
		}
		vala_code_context_pop ();
		result = 0;
		return result;
	} else {
		gboolean _tmp8_;
		_tmp8_ = vala_vapi_gen_quiet_mode;
		if (!_tmp8_) {
			FILE* _tmp9_;
			ValaCodeContext* _tmp10_;
			ValaReport* _tmp11_;
			ValaReport* _tmp12_;
			ValaCodeContext* _tmp13_;
			ValaReport* _tmp14_;
			ValaReport* _tmp15_;
			_tmp9_ = stdout;
			_tmp10_ = self->priv->context;
			_tmp11_ = vala_code_context_get_report (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = self->priv->context;
			_tmp14_ = vala_code_context_get_report (_tmp13_);
			_tmp15_ = _tmp14_;
			fprintf (_tmp9_, "Generation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp12_), vala_report_get_warnings (_tmp15_));
		}
		vala_code_context_pop ();
		result = 1;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             const gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gint
vala_vapi_gen_run (ValaVAPIGen* self)
{
	gint result = 0;
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaCodeContext* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValaCodeContext* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValaCodeContext* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	ValaCodeContext* _tmp9_;
	ValaReport* _tmp10_;
	ValaReport* _tmp11_;
	gboolean _tmp12_;
	ValaCodeContext* _tmp13_;
	ValaReport* _tmp14_;
	ValaReport* _tmp15_;
	gboolean _tmp16_;
	ValaCodeContext* _tmp17_;
	ValaCodeContext* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	ValaCodeContext* _tmp23_;
	ValaReport* _tmp24_;
	ValaReport* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	ValaCodeContext* _tmp41_;
	ValaReport* _tmp42_;
	ValaReport* _tmp43_;
	const gchar* _tmp44_;
	ValaCodeContext* _tmp49_;
	ValaReport* _tmp50_;
	ValaReport* _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	ValaCodeContext* _tmp57_;
	ValaReport* _tmp58_;
	ValaReport* _tmp59_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	ValaCodeContext* _tmp72_;
	ValaReport* _tmp73_;
	ValaReport* _tmp74_;
	ValaParser* parser = NULL;
	ValaParser* _tmp75_;
	ValaParser* _tmp76_;
	ValaCodeContext* _tmp77_;
	ValaCodeContext* _tmp78_;
	ValaReport* _tmp79_;
	ValaReport* _tmp80_;
	ValaGirParser* girparser = NULL;
	ValaGirParser* _tmp81_;
	ValaGirParser* _tmp82_;
	ValaCodeContext* _tmp83_;
	ValaCodeContext* _tmp84_;
	ValaReport* _tmp85_;
	ValaReport* _tmp86_;
	ValaGIdlParser* gidlparser = NULL;
	ValaGIdlParser* _tmp87_;
	ValaGIdlParser* _tmp88_;
	ValaCodeContext* _tmp89_;
	ValaCodeContext* _tmp90_;
	ValaReport* _tmp91_;
	ValaReport* _tmp92_;
	ValaCodeContext* _tmp93_;
	ValaCodeContext* _tmp94_;
	ValaReport* _tmp95_;
	ValaReport* _tmp96_;
	gchar** package_names = NULL;
	gchar** _tmp97_;
	gint package_names_length1;
	gint _package_names_size_;
	gchar* library_name = NULL;
	const gchar* _tmp154_;
	gchar* _tmp155_;
	gboolean _tmp156_ = FALSE;
	gchar** _tmp157_;
	gint _tmp157__length1;
	ValaCodeWriter* interface_writer = NULL;
	ValaCodeWriter* _tmp166_;
	gchar* vapi_filename = NULL;
	const gchar* _tmp167_;
	gchar* _tmp168_;
	const gchar* _tmp169_;
	ValaCodeWriter* _tmp173_;
	ValaCodeContext* _tmp174_;
	const gchar* _tmp175_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_set_profile (_tmp1_, VALA_PROFILE_GOBJECT);
	_tmp2_ = self->priv->context;
	vala_code_context_add_define (_tmp2_, "GOBJECT");
	_tmp3_ = self->priv->context;
	_tmp4_ = vala_vapi_gen_vapi_directories;
	_tmp4__length1 = _vala_array_length (vala_vapi_gen_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp3_, _tmp4_, _tmp4__length1);
	_tmp5_ = self->priv->context;
	_tmp6_ = vala_vapi_gen_gir_directories;
	_tmp6__length1 = _vala_array_length (vala_vapi_gen_gir_directories);
	vala_code_context_set_gir_directories (_tmp5_, _tmp6_, _tmp6__length1);
	_tmp7_ = self->priv->context;
	_tmp8_ = vala_vapi_gen_metadata_directories;
	_tmp8__length1 = _vala_array_length (vala_vapi_gen_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp7_, _tmp8_, _tmp8__length1);
	_tmp9_ = self->priv->context;
	_tmp10_ = vala_code_context_get_report (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_vapi_gen_disable_warnings;
	vala_report_set_enable_warnings (_tmp11_, !_tmp12_);
	_tmp13_ = self->priv->context;
	_tmp14_ = vala_code_context_get_report (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_vapi_gen_quiet_mode;
	vala_report_set_verbose_errors (_tmp15_, !_tmp16_);
	_tmp17_ = self->priv->context;
	vala_code_context_push (_tmp17_);
	_tmp18_ = self->priv->context;
	_tmp19_ = vala_vapi_gen_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp18_, _tmp19_);
	_tmp20_ = vala_vapi_gen_nostdpkg;
	if (!_tmp20_) {
		ValaCodeContext* _tmp21_;
		ValaCodeContext* _tmp22_;
		_tmp21_ = self->priv->context;
		vala_code_context_add_external_package (_tmp21_, "glib-2.0");
		_tmp22_ = self->priv->context;
		vala_code_context_add_external_package (_tmp22_, "gobject-2.0");
	}
	_tmp23_ = self->priv->context;
	_tmp24_ = vala_code_context_get_report (_tmp23_);
	_tmp25_ = _tmp24_;
	if (vala_report_get_errors (_tmp25_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp26_ = vala_vapi_gen_sources;
	_tmp26__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp26_;
		source_collection_length1 = _tmp26__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp27_;
			gchar* source = NULL;
			_tmp27_ = g_strdup (source_collection[source_it]);
			source = _tmp27_;
			{
				const gchar* _tmp28_;
				gchar* depsfile = NULL;
				const gchar* _tmp29_;
				const gchar* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				ValaCodeContext* _tmp39_;
				const gchar* _tmp40_;
				_tmp28_ = source;
				if (!g_str_has_suffix (_tmp28_, ".gi")) {
					_g_free0 (source);
					continue;
				}
				_tmp29_ = source;
				_tmp30_ = source;
				_tmp31_ = strlen (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = strlen ("gi");
				_tmp34_ = _tmp33_;
				_tmp35_ = string_substring (_tmp29_, (glong) 0, (glong) (_tmp32_ - _tmp34_));
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strconcat (_tmp36_, "deps", NULL);
				_tmp38_ = _tmp37_;
				_g_free0 (_tmp36_);
				depsfile = _tmp38_;
				_tmp39_ = self->priv->context;
				_tmp40_ = depsfile;
				vala_code_context_add_packages_from_file (_tmp39_, _tmp40_);
				_g_free0 (depsfile);
				_g_free0 (source);
			}
		}
	}
	_tmp41_ = self->priv->context;
	_tmp42_ = vala_code_context_get_report (_tmp41_);
	_tmp43_ = _tmp42_;
	if (vala_report_get_errors (_tmp43_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp44_ = vala_vapi_gen_library;
	if (_tmp44_ != NULL) {
		gchar* depsfile = NULL;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		ValaCodeContext* _tmp47_;
		const gchar* _tmp48_;
		_tmp45_ = vala_vapi_gen_library;
		_tmp46_ = g_strconcat (_tmp45_, ".deps", NULL);
		depsfile = _tmp46_;
		_tmp47_ = self->priv->context;
		_tmp48_ = depsfile;
		vala_code_context_add_packages_from_file (_tmp47_, _tmp48_);
		_g_free0 (depsfile);
	} else {
		vala_report_error (NULL, "--library option must be specified");
	}
	_tmp49_ = self->priv->context;
	_tmp50_ = vala_code_context_get_report (_tmp49_);
	_tmp51_ = _tmp50_;
	if (vala_report_get_errors (_tmp51_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp52_ = vala_vapi_gen_packages;
	_tmp52__length1 = _vala_array_length (vala_vapi_gen_packages);
	if (_tmp52_ != NULL) {
		gchar** _tmp53_;
		gint _tmp53__length1;
		_tmp53_ = vala_vapi_gen_packages;
		_tmp53__length1 = _vala_array_length (vala_vapi_gen_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp53_;
			package_collection_length1 = _tmp53__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp54_;
				gchar* package = NULL;
				_tmp54_ = g_strdup (package_collection[package_it]);
				package = _tmp54_;
				{
					ValaCodeContext* _tmp55_;
					const gchar* _tmp56_;
					_tmp55_ = self->priv->context;
					_tmp56_ = package;
					vala_code_context_add_external_package (_tmp55_, _tmp56_);
					_g_free0 (package);
				}
			}
		}
		vala_vapi_gen_packages = (_vala_array_free (vala_vapi_gen_packages, _vala_array_length (vala_vapi_gen_packages), (GDestroyNotify) g_free), NULL);
		vala_vapi_gen_packages = NULL;
	}
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_code_context_get_report (_tmp57_);
	_tmp59_ = _tmp58_;
	if (vala_report_get_errors (_tmp59_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp60_ = vala_vapi_gen_sources;
	_tmp60__length1 = _vala_array_length (vala_vapi_gen_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp60_;
		source_collection_length1 = _tmp60__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp61_;
			gchar* source = NULL;
			_tmp61_ = g_strdup (source_collection[source_it]);
			source = _tmp61_;
			{
				const gchar* _tmp62_;
				_tmp62_ = source;
				if (g_file_test (_tmp62_, G_FILE_TEST_EXISTS)) {
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp63_;
					const gchar* _tmp64_;
					ValaSourceFile* _tmp65_;
					ValaSourceFile* _tmp66_;
					ValaCodeContext* _tmp67_;
					ValaSourceFile* _tmp68_;
					_tmp63_ = self->priv->context;
					_tmp64_ = source;
					_tmp65_ = vala_source_file_new (_tmp63_, VALA_SOURCE_FILE_TYPE_PACKAGE, _tmp64_, NULL, FALSE);
					source_file = _tmp65_;
					_tmp66_ = source_file;
					vala_source_file_set_explicit (_tmp66_, TRUE);
					_tmp67_ = self->priv->context;
					_tmp68_ = source_file;
					vala_code_context_add_source_file (_tmp67_, _tmp68_);
					_vala_source_file_unref0 (source_file);
				} else {
					const gchar* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					_tmp69_ = source;
					_tmp70_ = g_strdup_printf ("%s not found", _tmp69_);
					_tmp71_ = _tmp70_;
					vala_report_error (NULL, _tmp71_);
					_g_free0 (_tmp71_);
				}
				_g_free0 (source);
			}
		}
	}
	_tmp72_ = self->priv->context;
	_tmp73_ = vala_code_context_get_report (_tmp72_);
	_tmp74_ = _tmp73_;
	if (vala_report_get_errors (_tmp74_) > 0) {
		result = vala_vapi_gen_quit (self);
		return result;
	}
	_tmp75_ = vala_parser_new ();
	parser = _tmp75_;
	_tmp76_ = parser;
	_tmp77_ = self->priv->context;
	vala_parser_parse (_tmp76_, _tmp77_);
	_tmp78_ = self->priv->context;
	_tmp79_ = vala_code_context_get_report (_tmp78_);
	_tmp80_ = _tmp79_;
	if (vala_report_get_errors (_tmp80_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp81_ = vala_gir_parser_new ();
	girparser = _tmp81_;
	_tmp82_ = girparser;
	_tmp83_ = self->priv->context;
	vala_gir_parser_parse (_tmp82_, _tmp83_);
	_tmp84_ = self->priv->context;
	_tmp85_ = vala_code_context_get_report (_tmp84_);
	_tmp86_ = _tmp85_;
	if (vala_report_get_errors (_tmp86_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp87_ = vala_gidl_parser_new ();
	gidlparser = _tmp87_;
	_tmp88_ = gidlparser;
	_tmp89_ = self->priv->context;
	vala_gidl_parser_parse (_tmp88_, _tmp89_);
	_tmp90_ = self->priv->context;
	_tmp91_ = vala_code_context_get_report (_tmp90_);
	_tmp92_ = _tmp91_;
	if (vala_report_get_errors (_tmp92_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp93_ = self->priv->context;
	vala_code_context_check (_tmp93_);
	_tmp94_ = self->priv->context;
	_tmp95_ = vala_code_context_get_report (_tmp94_);
	_tmp96_ = _tmp95_;
	if (vala_report_get_errors (_tmp96_) > 0) {
		result = vala_vapi_gen_quit (self);
		_vala_code_visitor_unref0 (gidlparser);
		_vala_code_visitor_unref0 (girparser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp97_ = g_new0 (gchar*, 0 + 1);
	package_names = _tmp97_;
	package_names_length1 = 0;
	_package_names_size_ = package_names_length1;
	{
		ValaList* _file_list = NULL;
		ValaCodeContext* _tmp98_;
		ValaList* _tmp99_;
		gint _file_size = 0;
		ValaList* _tmp100_;
		gint _tmp101_;
		gint _tmp102_;
		gint _file_index = 0;
		_tmp98_ = self->priv->context;
		_tmp99_ = vala_code_context_get_source_files (_tmp98_);
		_file_list = _tmp99_;
		_tmp100_ = _file_list;
		_tmp101_ = vala_collection_get_size ((ValaCollection*) _tmp100_);
		_tmp102_ = _tmp101_;
		_file_size = _tmp102_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp103_;
			gint _tmp104_;
			gint _tmp105_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp106_;
			gint _tmp107_;
			gpointer _tmp108_;
			ValaSourceFile* _tmp109_;
			const gchar* _tmp110_;
			const gchar* _tmp111_;
			ValaSourceFile* _tmp112_;
			const gchar* _tmp113_;
			const gchar* _tmp114_;
			gchar** _tmp115_;
			gint _tmp115__length1;
			_tmp103_ = _file_index;
			_file_index = _tmp103_ + 1;
			_tmp104_ = _file_index;
			_tmp105_ = _file_size;
			if (!(_tmp104_ < _tmp105_)) {
				break;
			}
			_tmp106_ = _file_list;
			_tmp107_ = _file_index;
			_tmp108_ = vala_list_get (_tmp106_, _tmp107_);
			file = (ValaSourceFile*) _tmp108_;
			_tmp109_ = file;
			_tmp110_ = vala_source_file_get_filename (_tmp109_);
			_tmp111_ = _tmp110_;
			if (g_str_has_suffix (_tmp111_, ".vapi")) {
				_vala_source_file_unref0 (file);
				continue;
			}
			_tmp112_ = file;
			_tmp113_ = vala_source_file_get_filename (_tmp112_);
			_tmp114_ = _tmp113_;
			_tmp115_ = vala_vapi_gen_sources;
			_tmp115__length1 = _vala_array_length (vala_vapi_gen_sources);
			if (_vala_string_array_contains (_tmp115_, _tmp115__length1, _tmp114_)) {
				ValaSourceFile* _tmp116_;
				ValaSourceFile* _tmp117_;
				const gchar* _tmp118_;
				const gchar* _tmp119_;
				_tmp116_ = file;
				vala_source_file_set_file_type (_tmp116_, VALA_SOURCE_FILE_TYPE_SOURCE);
				_tmp117_ = file;
				_tmp118_ = vala_source_file_get_filename (_tmp117_);
				_tmp119_ = _tmp118_;
				if (g_str_has_suffix (_tmp119_, ".gir")) {
					gchar* metadata_filename = NULL;
					ValaCodeContext* _tmp120_;
					ValaSourceFile* _tmp121_;
					const gchar* _tmp122_;
					const gchar* _tmp123_;
					gchar* _tmp124_;
					const gchar* _tmp125_;
					gboolean _tmp142_ = FALSE;
					ValaSourceFile* _tmp143_;
					gboolean _tmp144_;
					gboolean _tmp145_;
					_tmp120_ = self->priv->context;
					_tmp121_ = file;
					_tmp122_ = vala_source_file_get_filename (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_code_context_get_metadata_path (_tmp120_, _tmp123_);
					metadata_filename = _tmp124_;
					_tmp125_ = metadata_filename;
					if (_tmp125_ != NULL) {
						{
							ValaList* _metadata_file_list = NULL;
							ValaCodeContext* _tmp126_;
							ValaList* _tmp127_;
							gint _metadata_file_size = 0;
							ValaList* _tmp128_;
							gint _tmp129_;
							gint _tmp130_;
							gint _metadata_file_index = 0;
							_tmp126_ = self->priv->context;
							_tmp127_ = vala_code_context_get_source_files (_tmp126_);
							_metadata_file_list = _tmp127_;
							_tmp128_ = _metadata_file_list;
							_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
							_tmp130_ = _tmp129_;
							_metadata_file_size = _tmp130_;
							_metadata_file_index = -1;
							while (TRUE) {
								gint _tmp131_;
								gint _tmp132_;
								gint _tmp133_;
								ValaSourceFile* metadata_file = NULL;
								ValaList* _tmp134_;
								gint _tmp135_;
								gpointer _tmp136_;
								ValaSourceFile* _tmp137_;
								const gchar* _tmp138_;
								const gchar* _tmp139_;
								const gchar* _tmp140_;
								_tmp131_ = _metadata_file_index;
								_metadata_file_index = _tmp131_ + 1;
								_tmp132_ = _metadata_file_index;
								_tmp133_ = _metadata_file_size;
								if (!(_tmp132_ < _tmp133_)) {
									break;
								}
								_tmp134_ = _metadata_file_list;
								_tmp135_ = _metadata_file_index;
								_tmp136_ = vala_list_get (_tmp134_, _tmp135_);
								metadata_file = (ValaSourceFile*) _tmp136_;
								_tmp137_ = metadata_file;
								_tmp138_ = vala_source_file_get_filename (_tmp137_);
								_tmp139_ = _tmp138_;
								_tmp140_ = metadata_filename;
								if (g_strcmp0 (_tmp139_, _tmp140_) == 0) {
									ValaSourceFile* _tmp141_;
									_tmp141_ = metadata_file;
									vala_source_file_set_file_type (_tmp141_, VALA_SOURCE_FILE_TYPE_SOURCE);
								}
								_vala_source_file_unref0 (metadata_file);
							}
							_vala_iterable_unref0 (_metadata_file_list);
						}
					}
					_tmp143_ = file;
					_tmp144_ = vala_source_file_get_explicit (_tmp143_);
					_tmp145_ = _tmp144_;
					if (_tmp145_) {
						ValaSourceFile* _tmp146_;
						const gchar* _tmp147_;
						const gchar* _tmp148_;
						_tmp146_ = file;
						_tmp147_ = vala_source_file_get_package_name (_tmp146_);
						_tmp148_ = _tmp147_;
						_tmp142_ = _tmp148_ != NULL;
					} else {
						_tmp142_ = FALSE;
					}
					if (_tmp142_) {
						gchar** _tmp149_;
						gint _tmp149__length1;
						ValaSourceFile* _tmp150_;
						const gchar* _tmp151_;
						const gchar* _tmp152_;
						gchar* _tmp153_;
						_tmp149_ = package_names;
						_tmp149__length1 = package_names_length1;
						_tmp150_ = file;
						_tmp151_ = vala_source_file_get_package_name (_tmp150_);
						_tmp152_ = _tmp151_;
						_tmp153_ = g_strdup (_tmp152_);
						_vala_array_add1 (&package_names, &package_names_length1, &_package_names_size_, _tmp153_);
					}
					_g_free0 (metadata_filename);
				}
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_tmp154_ = vala_vapi_gen_library;
	_tmp155_ = g_path_get_basename (_tmp154_);
	library_name = _tmp155_;
	_tmp157_ = package_names;
	_tmp157__length1 = package_names_length1;
	if (_tmp157__length1 > 0) {
		const gchar* _tmp158_;
		gchar** _tmp159_;
		gint _tmp159__length1;
		_tmp158_ = library_name;
		_tmp159_ = package_names;
		_tmp159__length1 = package_names_length1;
		_tmp156_ = !_vala_string_array_contains (_tmp159_, _tmp159__length1, _tmp158_);
	} else {
		_tmp156_ = FALSE;
	}
	if (_tmp156_) {
		const gchar* _tmp160_;
		gchar** _tmp161_;
		gint _tmp161__length1;
		gchar* _tmp162_;
		gchar* _tmp163_;
		gchar* _tmp164_;
		gchar* _tmp165_;
		_tmp160_ = library_name;
		_tmp161_ = package_names;
		_tmp161__length1 = package_names_length1;
		_tmp162_ = g_strjoin ("', `", _tmp161_, NULL);
		_tmp163_ = _tmp162_;
		_tmp164_ = g_strdup_printf ("Given library name `%s' does not match pkg-config name `%s'", _tmp160_, _tmp163_);
		_tmp165_ = _tmp164_;
		vala_report_warning (NULL, _tmp165_);
		_g_free0 (_tmp165_);
		_g_free0 (_tmp163_);
	}
	_tmp166_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_VAPIGEN);
	interface_writer = _tmp166_;
	_tmp167_ = vala_vapi_gen_library;
	_tmp168_ = g_strdup_printf ("%s.vapi", _tmp167_);
	vapi_filename = _tmp168_;
	_tmp169_ = vala_vapi_gen_directory;
	if (_tmp169_ != NULL) {
		const gchar* _tmp170_;
		const gchar* _tmp171_;
		gchar* _tmp172_;
		_tmp170_ = vala_vapi_gen_directory;
		_tmp171_ = vapi_filename;
		_tmp172_ = g_build_path ("/", _tmp170_, _tmp171_, NULL);
		_g_free0 (vapi_filename);
		vapi_filename = _tmp172_;
	}
	_tmp173_ = interface_writer;
	_tmp174_ = self->priv->context;
	_tmp175_ = vapi_filename;
	vala_code_writer_write_file (_tmp173_, _tmp174_, _tmp175_);
	_g_free0 (vala_vapi_gen_library);
	vala_vapi_gen_library = NULL;
	result = vala_vapi_gen_quit (self);
	_g_free0 (vapi_filename);
	_vala_code_visitor_unref0 (interface_writer);
	_g_free0 (library_name);
	package_names = (_vala_array_free (package_names, package_names_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_visitor_unref0 (gidlparser);
	_vala_code_visitor_unref0 (girparser);
	_vala_code_visitor_unref0 (parser);
	return result;
}


static gint
vala_vapi_gen_main (gchar** args,
                    int args_length1)
{
	gint result = 0;
	gboolean _tmp11_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	ValaVAPIGen* vapigen = NULL;
	ValaVAPIGen* _tmp15_;
	ValaVAPIGen* _tmp16_;
	GError* _inner_error0_ = NULL;
	setlocale (LC_ALL, "");
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala API Generator");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_VAPI_GEN_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, &args_length1, &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch4_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally4;
	__catch4_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	_tmp11_ = vala_vapi_gen_version;
	if (_tmp11_) {
		FILE* _tmp12_;
		_tmp12_ = stdout;
		fprintf (_tmp12_, "Vala API Generator %s\n", BUILD_VERSION);
		result = 0;
		return result;
	}
	_tmp13_ = vala_vapi_gen_sources;
	_tmp13__length1 = _vala_array_length (vala_vapi_gen_sources);
	if (_tmp13_ == NULL) {
		FILE* _tmp14_;
		_tmp14_ = stderr;
		fprintf (_tmp14_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp15_ = vala_vapi_gen_new ();
	vapigen = _tmp15_;
	_tmp16_ = vapigen;
	result = vala_vapi_gen_run (_tmp16_);
	_vala_vapi_gen_unref0 (vapigen);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return vala_vapi_gen_main (argv, argc);
}


G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_construct (GType object_type)
{
	ValaVAPIGen* self = NULL;
	self = (ValaVAPIGen*) g_type_create_instance (object_type);
	return self;
}


G_GNUC_INTERNAL ValaVAPIGen*
vala_vapi_gen_new (void)
{
	return vala_vapi_gen_construct (VALA_TYPE_VAPI_GEN);
}


static void
vala_value_vapi_gen_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_vapi_gen_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_vapi_gen_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_vapi_gen_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_vapi_gen_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_vapi_gen_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_vapi_gen_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaVAPIGen * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_vapi_gen_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_vapi_gen_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaVAPIGen ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_vapi_gen_ref (value->data[0].v_pointer);
	}
	return NULL;
}


G_GNUC_INTERNAL GParamSpec*
vala_param_spec_vapi_gen (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecVAPIGen* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_VAPI_GEN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


G_GNUC_INTERNAL gpointer
vala_value_get_vapi_gen (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN), NULL);
	return value->data[0].v_pointer;
}


G_GNUC_INTERNAL void
vala_value_set_vapi_gen (GValue* value,
                         gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_vapi_gen_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}


G_GNUC_INTERNAL void
vala_value_take_vapi_gen (GValue* value,
                          gpointer v_object)
{
	ValaVAPIGen * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_VAPI_GEN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_VAPI_GEN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_vapi_gen_unref (old);
	}
}


static void
vala_vapi_gen_class_init (ValaVAPIGenClass * klass)
{
	vala_vapi_gen_parent_class = g_type_class_peek_parent (klass);
	((ValaVAPIGenClass *) klass)->finalize = vala_vapi_gen_finalize;
	g_type_class_add_private (klass, sizeof (ValaVAPIGenPrivate));
}


static void
vala_vapi_gen_instance_init (ValaVAPIGen * self)
{
	self->priv = VALA_VAPI_GEN_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_vapi_gen_finalize (ValaVAPIGen * obj)
{
	ValaVAPIGen * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_VAPI_GEN, ValaVAPIGen);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}


G_GNUC_INTERNAL GType
vala_vapi_gen_get_type (void)
{
	static volatile gsize vala_vapi_gen_type_id__volatile = 0;
	if (g_once_init_enter (&vala_vapi_gen_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_vapi_gen_init, vala_value_vapi_gen_free_value, vala_value_vapi_gen_copy_value, vala_value_vapi_gen_peek_pointer, "p", vala_value_vapi_gen_collect_value, "p", vala_value_vapi_gen_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaVAPIGenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_vapi_gen_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaVAPIGen), 0, (GInstanceInitFunc) vala_vapi_gen_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_vapi_gen_type_id;
		vala_vapi_gen_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaVAPIGen", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_vapi_gen_type_id__volatile, vala_vapi_gen_type_id);
	}
	return vala_vapi_gen_type_id__volatile;
}


G_GNUC_INTERNAL gpointer
vala_vapi_gen_ref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


G_GNUC_INTERNAL void
vala_vapi_gen_unref (gpointer instance)
{
	ValaVAPIGen * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_VAPI_GEN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



