// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SHSUB_8H_TRACE_AARCH64_H_
#define VIXL_SIM_SHSUB_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_shsub_8H[] = {
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0x3fff, 0xffff,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0x3fff, 0x3fff, 0xffff,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0x3ffe, 0x3ffe, 0x3ffe, 0xfff8,
  0xc040, 0xc040, 0xd99a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xffc1,
  0xc040, 0xc040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xffc1,
  0xc03f, 0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xffc0,
  0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xe666,
  0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0xd555,
  0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0xc001,
  0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0xc001,
  0x0000, 0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0xc000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0x7fff, 0x3fff,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0x7fff, 0x7fff, 0x2aab,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0x7ffe, 0x7ffe, 0x6aaa, 0x199a,
  0xc040, 0xc040, 0xd99a, 0x6aaa, 0x7ffe, 0x6aaa, 0x5999, 0x0040,
  0xc040, 0xc040, 0x5999, 0x6aaa, 0x6aa9, 0x5999, 0x403f, 0x003f,
  0xc03f, 0x403f, 0x5999, 0x5555, 0x5998, 0x403f, 0x403f, 0x003f,
  0x403f, 0x403f, 0x4444, 0x4444, 0x403e, 0x403e, 0x403e, 0x003e,
  0x403e, 0x2aea, 0x3333, 0x2aea, 0x403e, 0x403e, 0x403e, 0x0008,
  0x2aea, 0x19d9, 0x19d9, 0x2aea, 0x403d, 0x403d, 0x4007, 0x0001,
  0x19d9, 0x007f, 0x19d9, 0x2ae9, 0x403d, 0x4007, 0x4001, 0x0001,
  0x007f, 0x007f, 0x19d8, 0x2ae9, 0x4006, 0x4000, 0x4000, 0x0000,
  0x007f, 0x19d8, 0x2ae9, 0x4006, 0x4000, 0x4000, 0x0000, 0x0000,
  0x007e, 0x19d8, 0x2ab2, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000,
  0x007e, 0x19a1, 0x2aac, 0x3fff, 0x3fff, 0x3fff, 0xffff, 0xffff,
  0x0047, 0x199b, 0x2aab, 0x3fff, 0x3fff, 0x3fff, 0xffff, 0xfff8,
  0x0041, 0x199a, 0x2aab, 0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0xffc2,
  0x0040, 0x199a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0xffc1,
  0x0040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0xffc1,
  0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0xe667,
  0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0xd556,
  0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0xd555, 0xc002,
  0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0xc001, 0xc001,
  0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0xc001, 0xc001,
  0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0xc000, 0x4000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x4000,
  0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0x7fff, 0x3fff, 0x2aab,
  0xd595, 0xd99b, 0xeaab, 0xffff, 0x7fff, 0x7fff, 0x2aab, 0x199a,
  0xc041, 0xd99a, 0xeaab, 0x7ffe, 0x7ffe, 0x6aaa, 0x199a, 0x0040,
  0xc040, 0xd99a, 0x6aaa, 0x7ffe, 0x6aaa, 0x5999, 0x0040, 0x0040,
  0xc040, 0x5999, 0x6aaa, 0x6aa9, 0x5999, 0x403f, 0x003f, 0x003f,
  0x403f, 0x5999, 0x5555, 0x5998, 0x403f, 0x403f, 0x003f, 0x003f,
  0x403f, 0x4444, 0x4444, 0x403e, 0x403e, 0x403e, 0x003e, 0x0008,
  0x2aea, 0x3333, 0x2aea, 0x403e, 0x403e, 0x403e, 0x0008, 0x0002,
  0x19d9, 0x19d9, 0x2aea, 0x403d, 0x403d, 0x4007, 0x0001, 0x0001,
  0x007f, 0x19d9, 0x2ae9, 0x403d, 0x4007, 0x4001, 0x0001, 0x0001,
  0x19d9, 0x2ae9, 0x403d, 0x4007, 0x4001, 0x0001, 0x0001, 0x0001,
  0x19d8, 0x2ae9, 0x4006, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000,
  0x19d8, 0x2ab2, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000,
  0x19a1, 0x2aac, 0x3fff, 0x3fff, 0x3fff, 0xffff, 0xffff, 0xfff9,
  0x199b, 0x2aab, 0x3fff, 0x3fff, 0x3fff, 0xffff, 0xfff8, 0xffc2,
  0x199a, 0x2aab, 0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0xffc2,
  0x199a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0xffc1,
  0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0xe667,
  0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0xd556,
  0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0xd556, 0xc002,
  0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0xd555, 0xc002, 0xc002,
  0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0xc001, 0xc001, 0xc001,
  0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0xc001, 0xc001, 0x4001,
  0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0xc000, 0x4000, 0x4000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x4000, 0x2aac,
  0xeeef, 0xeaac, 0xffff, 0xffff, 0x7fff, 0x3fff, 0x2aab, 0x199b,
  0xd99b, 0xeaab, 0xffff, 0x7fff, 0x7fff, 0x2aab, 0x199a, 0x0041,
  0xd99a, 0xeaab, 0x7ffe, 0x7ffe, 0x6aaa, 0x199a, 0x0040, 0x0040,
  0xd99a, 0x6aaa, 0x7ffe, 0x6aaa, 0x5999, 0x0040, 0x0040, 0x0040,
  0x5999, 0x6aaa, 0x6aa9, 0x5999, 0x403f, 0x003f, 0x003f, 0x003f,
  0x5999, 0x5555, 0x5998, 0x403f, 0x403f, 0x003f, 0x003f, 0x0009,
  0x4444, 0x4444, 0x403e, 0x403e, 0x403e, 0x003e, 0x0008, 0x0002,
  0x3333, 0x2aea, 0x403e, 0x403e, 0x403e, 0x0008, 0x0002, 0x0002,
  0x19d9, 0x2aea, 0x403d, 0x403d, 0x4007, 0x0001, 0x0001, 0x0001,
  0x2aea, 0x403d, 0x403d, 0x4007, 0x0001, 0x0001, 0x0001, 0x0008,
  0x2ae9, 0x403d, 0x4007, 0x4001, 0x0001, 0x0001, 0x0001, 0x0007,
  0x2ae9, 0x4006, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0007,
  0x2ab2, 0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aac, 0x3fff, 0x3fff, 0x3fff, 0xffff, 0xffff, 0xfff9, 0xffc9,
  0x2aab, 0x3fff, 0x3fff, 0x3fff, 0xffff, 0xfff8, 0xffc2, 0xffc9,
  0x2aab, 0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0xffc8,
  0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0xe66e,
  0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0xe667, 0xd55d,
  0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0xd556, 0xc009,
  0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0xd556, 0xc002, 0xc009,
  0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0xd555, 0xc002, 0xc002, 0xc008,
  0x2a6b, 0x3fbf, 0x2665, 0x1555, 0xc001, 0xc001, 0xc001, 0x4008,
  0x2a6b, 0x2665, 0x1554, 0x0001, 0xc001, 0xc001, 0x4001, 0x4007,
  0x1111, 0x1554, 0x0000, 0x0000, 0xc000, 0x4000, 0x4000, 0x2ab3,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4000, 0x4000, 0x2aac, 0x19a2,
  0xeaac, 0xffff, 0xffff, 0x7fff, 0x3fff, 0x2aab, 0x199b, 0x0048,
  0xeaab, 0xffff, 0x7fff, 0x7fff, 0x2aab, 0x199a, 0x0041, 0x0047,
  0xeaab, 0x7ffe, 0x7ffe, 0x6aaa, 0x199a, 0x0040, 0x0040, 0x0047,
  0x6aaa, 0x7ffe, 0x6aaa, 0x5999, 0x0040, 0x0040, 0x0040, 0x0046,
  0x6aaa, 0x6aa9, 0x5999, 0x403f, 0x003f, 0x003f, 0x003f, 0x0010,
  0x5555, 0x5998, 0x403f, 0x403f, 0x003f, 0x003f, 0x0009, 0x0009,
  0x4444, 0x403e, 0x403e, 0x403e, 0x003e, 0x0008, 0x0002, 0x0009,
  0x2aea, 0x403e, 0x403e, 0x403e, 0x0008, 0x0002, 0x0002, 0x0008,
  0x403e, 0x403e, 0x403e, 0x0008, 0x0002, 0x0002, 0x0008, 0x003e,
  0x403d, 0x403d, 0x4007, 0x0001, 0x0001, 0x0001, 0x0008, 0x003e,
  0x403d, 0x4007, 0x4001, 0x0001, 0x0001, 0x0001, 0x0007, 0x003d,
  0x4006, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0036,
  0x4000, 0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x3fff, 0x3fff, 0xffff, 0xffff, 0xfff9, 0xffc9, 0xffff,
  0x3fff, 0x3fff, 0x3fff, 0xffff, 0xfff8, 0xffc2, 0xffc9, 0xffff,
  0x3ffe, 0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0xffc8, 0xe6a5,
  0x3ffe, 0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0xe66e, 0xd594,
  0x3ffd, 0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0xe667, 0xd55d, 0xc040,
  0x3ff6, 0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0xd556, 0xc009, 0xc03f,
  0x3fc0, 0x3fc0, 0x3fc0, 0xe666, 0xd556, 0xc002, 0xc009, 0xc03f,
  0x3fbf, 0x3fbf, 0x2666, 0xd555, 0xc002, 0xc002, 0xc008, 0x403e,
  0x3fbf, 0x2665, 0x1555, 0xc001, 0xc001, 0xc001, 0x4008, 0x403e,
  0x2665, 0x1554, 0x0001, 0xc001, 0xc001, 0x4001, 0x4007, 0x2ae9,
  0x1554, 0x0000, 0x0000, 0xc000, 0x4000, 0x4000, 0x2ab3, 0x19d8,
  0x0000, 0x0000, 0x0000, 0x4000, 0x4000, 0x2aac, 0x19a2, 0x007e,
  0xffff, 0xffff, 0x7fff, 0x3fff, 0x2aab, 0x199b, 0x0048, 0x007e,
  0xffff, 0x7fff, 0x7fff, 0x2aab, 0x199a, 0x0041, 0x0047, 0x007d,
  0x7ffe, 0x7ffe, 0x6aaa, 0x199a, 0x0040, 0x0040, 0x0047, 0x007d,
  0x7ffe, 0x6aaa, 0x5999, 0x0040, 0x0040, 0x0040, 0x0046, 0x0046,
  0x6aa9, 0x5999, 0x403f, 0x003f, 0x003f, 0x003f, 0x0010, 0x0040,
  0x5998, 0x403f, 0x403f, 0x003f, 0x003f, 0x0009, 0x0009, 0x003f,
  0x403e, 0x403e, 0x403e, 0x003e, 0x0008, 0x0002, 0x0009, 0x003f,
  0x403e, 0x403e, 0x003e, 0x0008, 0x0002, 0x0009, 0x003f, 0x003f,
  0x403e, 0x403e, 0x0008, 0x0002, 0x0002, 0x0008, 0x003e, 0x003e,
  0x403d, 0x4007, 0x0001, 0x0001, 0x0001, 0x0008, 0x003e, 0x003e,
  0x4007, 0x4001, 0x0001, 0x0001, 0x0001, 0x0007, 0x003d, 0x0037,
  0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0036, 0x0000,
  0x4000, 0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0x3fff, 0xffff, 0xffff, 0xfff9, 0xffc9, 0xffff, 0xffff,
  0x3fff, 0x3fff, 0xffff, 0xfff8, 0xffc2, 0xffc9, 0xffff, 0xe6a5,
  0x3ffe, 0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0xd594,
  0x3ffe, 0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0xe66e, 0xd594, 0xc040,
  0x3ff7, 0x3fc1, 0xffc1, 0xffc1, 0xe667, 0xd55d, 0xc040, 0xc040,
  0x3fc0, 0x3fc0, 0xffc0, 0xe667, 0xd556, 0xc009, 0xc03f, 0xc03f,
  0x3fc0, 0x3fc0, 0xe666, 0xd556, 0xc002, 0xc009, 0xc03f, 0x403f,
  0x3fbf, 0x2666, 0xd555, 0xc002, 0xc002, 0xc008, 0x403e, 0x403e,
  0x2665, 0x1555, 0xc001, 0xc001, 0xc001, 0x4008, 0x403e, 0x2aea,
  0x1554, 0x0001, 0xc001, 0xc001, 0x4001, 0x4007, 0x2ae9, 0x19d9,
  0x0000, 0x0000, 0xc000, 0x4000, 0x4000, 0x2ab3, 0x19d8, 0x007f,
  0x0000, 0x0000, 0x4000, 0x4000, 0x2aac, 0x19a2, 0x007e, 0x007e,
  0xffff, 0x7fff, 0x3fff, 0x2aab, 0x199b, 0x0048, 0x007e, 0x007e,
  0x7fff, 0x7fff, 0x2aab, 0x199a, 0x0041, 0x0047, 0x007d, 0x007d,
  0x7ffe, 0x6aaa, 0x199a, 0x0040, 0x0040, 0x0047, 0x007d, 0x0047,
  0x6aaa, 0x5999, 0x0040, 0x0040, 0x0040, 0x0046, 0x0046, 0x0040,
  0x5999, 0x403f, 0x003f, 0x003f, 0x003f, 0x0010, 0x0040, 0x0040,
  0x403f, 0x403f, 0x003f, 0x003f, 0x0009, 0x0009, 0x003f, 0x003f,
  0x403f, 0x003f, 0x003f, 0x0009, 0x0009, 0x003f, 0x003f, 0x003f,
  0x403e, 0x003e, 0x0008, 0x0002, 0x0009, 0x003f, 0x003f, 0x003f,
  0x403e, 0x0008, 0x0002, 0x0002, 0x0008, 0x003e, 0x003e, 0x003e,
  0x4007, 0x0001, 0x0001, 0x0001, 0x0008, 0x003e, 0x003e, 0x0037,
  0x4001, 0x0001, 0x0001, 0x0001, 0x0007, 0x003d, 0x0037, 0x0001,
  0x4000, 0x0000, 0x0000, 0x0000, 0x0007, 0x0036, 0x0000, 0x0000,
  0x4000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fff, 0xffff, 0xffff, 0xfff9, 0xffc9, 0xffff, 0xffff, 0xe6a6,
  0x3fff, 0xffff, 0xfff8, 0xffc2, 0xffc9, 0xffff, 0xe6a5, 0xd595,
  0x3ffe, 0xfff8, 0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0xd594, 0xc041,
  0x3ff7, 0xffc1, 0xffc1, 0xffc1, 0xe66e, 0xd594, 0xc040, 0xc040,
  0x3fc1, 0xffc1, 0xffc1, 0xe667, 0xd55d, 0xc040, 0xc040, 0xc040,
  0x3fc0, 0xffc0, 0xe667, 0xd556, 0xc009, 0xc03f, 0xc03f, 0x403f,
  0x3fc0, 0xe666, 0xd556, 0xc002, 0xc009, 0xc03f, 0x403f, 0x403f,
  0x2666, 0xd555, 0xc002, 0xc002, 0xc008, 0x403e, 0x403e, 0x2aea,
  0x1555, 0xc001, 0xc001, 0xc001, 0x4008, 0x403e, 0x2aea, 0x19d9,
  0x0001, 0xc001, 0xc001, 0x4001, 0x4007, 0x2ae9, 0x19d9, 0x007f,
  0x0000, 0xc000, 0x4000, 0x4000, 0x2ab3, 0x19d8, 0x007f, 0x007f,
  0x0000, 0x4000, 0x4000, 0x2aac, 0x19a2, 0x007e, 0x007e, 0x007e,
  0x7fff, 0x3fff, 0x2aab, 0x199b, 0x0048, 0x007e, 0x007e, 0x007e,
  0x7fff, 0x2aab, 0x199a, 0x0041, 0x0047, 0x007d, 0x007d, 0x0047,
  0x6aaa, 0x199a, 0x0040, 0x0040, 0x0047, 0x007d, 0x0047, 0x0041,
  0x5999, 0x0040, 0x0040, 0x0040, 0x0046, 0x0046, 0x0040, 0x0040,
  0x403f, 0x003f, 0x003f, 0x003f, 0x0010, 0x0040, 0x0040, 0x0040,
  0x003f, 0x003f, 0x003f, 0x0010, 0x0040, 0x0040, 0x0040, 0x1999,
  0x003f, 0x003f, 0x0009, 0x0009, 0x003f, 0x003f, 0x003f, 0x1999,
  0x003e, 0x0008, 0x0002, 0x0009, 0x003f, 0x003f, 0x003f, 0x1998,
  0x0008, 0x0002, 0x0002, 0x0008, 0x003e, 0x003e, 0x003e, 0x1991,
  0x0001, 0x0001, 0x0001, 0x0008, 0x003e, 0x003e, 0x0037, 0x195b,
  0x0001, 0x0001, 0x0001, 0x0007, 0x003d, 0x0037, 0x0001, 0x195a,
  0x0000, 0x0000, 0x0000, 0x0007, 0x0036, 0x0000, 0x0000, 0x195a,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xfff9, 0xffc9, 0xffff, 0xffff, 0xe6a6, 0xeeef,
  0xffff, 0xfff8, 0xffc2, 0xffc9, 0xffff, 0xe6a5, 0xd595, 0xd99b,
  0xfff8, 0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0xd594, 0xc041, 0xd99a,
  0xffc1, 0xffc1, 0xffc1, 0xe66e, 0xd594, 0xc040, 0xc040, 0xd99a,
  0xffc1, 0xffc1, 0xe667, 0xd55d, 0xc040, 0xc040, 0xc040, 0x5999,
  0xffc0, 0xe667, 0xd556, 0xc009, 0xc03f, 0xc03f, 0x403f, 0x5999,
  0xe666, 0xd556, 0xc002, 0xc009, 0xc03f, 0x403f, 0x403f, 0x4444,
  0xd555, 0xc002, 0xc002, 0xc008, 0x403e, 0x403e, 0x2aea, 0x3333,
  0xc001, 0xc001, 0xc001, 0x4008, 0x403e, 0x2aea, 0x19d9, 0x19d9,
  0xc001, 0xc001, 0x4001, 0x4007, 0x2ae9, 0x19d9, 0x007f, 0x19d9,
  0xc000, 0x4000, 0x4000, 0x2ab3, 0x19d8, 0x007f, 0x007f, 0x19d8,
  0x4000, 0x4000, 0x2aac, 0x19a2, 0x007e, 0x007e, 0x007e, 0x19d8,
  0x3fff, 0x2aab, 0x199b, 0x0048, 0x007e, 0x007e, 0x007e, 0x19a1,
  0x2aab, 0x199a, 0x0041, 0x0047, 0x007d, 0x007d, 0x0047, 0x199b,
  0x199a, 0x0040, 0x0040, 0x0047, 0x007d, 0x0047, 0x0041, 0x199a,
  0x0040, 0x0040, 0x0040, 0x0046, 0x0046, 0x0040, 0x0040, 0x199a,
  0x0040, 0x0040, 0x0046, 0x0046, 0x0040, 0x0040, 0x199a, 0x2aaa,
  0x003f, 0x003f, 0x0010, 0x0040, 0x0040, 0x0040, 0x1999, 0x2aaa,
  0x003f, 0x0009, 0x0009, 0x003f, 0x003f, 0x003f, 0x1999, 0x2aa9,
  0x0008, 0x0002, 0x0009, 0x003f, 0x003f, 0x003f, 0x1998, 0x2aa2,
  0x0002, 0x0002, 0x0008, 0x003e, 0x003e, 0x003e, 0x1991, 0x2a6c,
  0x0001, 0x0001, 0x0008, 0x003e, 0x003e, 0x0037, 0x195b, 0x2a6b,
  0x0001, 0x0001, 0x0007, 0x003d, 0x0037, 0x0001, 0x195a, 0x2a6b,
  0x0000, 0x0000, 0x0007, 0x0036, 0x0000, 0x0000, 0x195a, 0x1111,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xfff9, 0xffc9, 0xffff, 0xffff, 0xe6a6, 0xeeef, 0xeaac,
  0xfff8, 0xffc2, 0xffc9, 0xffff, 0xe6a5, 0xd595, 0xd99b, 0xeaab,
  0xffc2, 0xffc2, 0xffc8, 0xe6a5, 0xd594, 0xc041, 0xd99a, 0xeaab,
  0xffc1, 0xffc1, 0xe66e, 0xd594, 0xc040, 0xc040, 0xd99a, 0x6aaa,
  0xffc1, 0xe667, 0xd55d, 0xc040, 0xc040, 0xc040, 0x5999, 0x6aaa,
  0xe667, 0xd556, 0xc009, 0xc03f, 0xc03f, 0x403f, 0x5999, 0x5555,
  0xd556, 0xc002, 0xc009, 0xc03f, 0x403f, 0x403f, 0x4444, 0x4444,
  0xc002, 0xc002, 0xc008, 0x403e, 0x403e, 0x2aea, 0x3333, 0x2aea,
  0xc001, 0xc001, 0x4008, 0x403e, 0x2aea, 0x19d9, 0x19d9, 0x2aea,
  0xc001, 0x4001, 0x4007, 0x2ae9, 0x19d9, 0x007f, 0x19d9, 0x2ae9,
  0x4000, 0x4000, 0x2ab3, 0x19d8, 0x007f, 0x007f, 0x19d8, 0x2ae9,
  0x4000, 0x2aac, 0x19a2, 0x007e, 0x007e, 0x007e, 0x19d8, 0x2ab2,
  0x2aab, 0x199b, 0x0048, 0x007e, 0x007e, 0x007e, 0x19a1, 0x2aac,
  0x199a, 0x0041, 0x0047, 0x007d, 0x007d, 0x0047, 0x199b, 0x2aab,
  0x0040, 0x0040, 0x0047, 0x007d, 0x0047, 0x0041, 0x199a, 0x2aab,
  0x0040, 0x0047, 0x007d, 0x0047, 0x0041, 0x199a, 0x2aab, 0x3ffe,
  0x0040, 0x0046, 0x0046, 0x0040, 0x0040, 0x199a, 0x2aaa, 0x3ffe,
  0x003f, 0x0010, 0x0040, 0x0040, 0x0040, 0x1999, 0x2aaa, 0x3ffd,
  0x0009, 0x0009, 0x003f, 0x003f, 0x003f, 0x1999, 0x2aa9, 0x3ff6,
  0x0002, 0x0009, 0x003f, 0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0,
  0x0002, 0x0008, 0x003e, 0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf,
  0x0001, 0x0008, 0x003e, 0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf,
  0x0001, 0x0007, 0x003d, 0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665,
  0x0000, 0x0007, 0x0036, 0x0000, 0x0000, 0x195a, 0x1111, 0x1554,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xfff9, 0xffc9, 0xffff, 0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff,
  0xffc2, 0xffc9, 0xffff, 0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff,
  0xffc2, 0xffc8, 0xe6a5, 0xd594, 0xc041, 0xd99a, 0xeaab, 0x7ffe,
  0xffc1, 0xe66e, 0xd594, 0xc040, 0xc040, 0xd99a, 0x6aaa, 0x7ffe,
  0xe667, 0xd55d, 0xc040, 0xc040, 0xc040, 0x5999, 0x6aaa, 0x6aa9,
  0xd556, 0xc009, 0xc03f, 0xc03f, 0x403f, 0x5999, 0x5555, 0x5998,
  0xc002, 0xc009, 0xc03f, 0x403f, 0x403f, 0x4444, 0x4444, 0x403e,
  0xc002, 0xc008, 0x403e, 0x403e, 0x2aea, 0x3333, 0x2aea, 0x403e,
  0xc001, 0x4008, 0x403e, 0x2aea, 0x19d9, 0x19d9, 0x2aea, 0x403d,
  0x4001, 0x4007, 0x2ae9, 0x19d9, 0x007f, 0x19d9, 0x2ae9, 0x403d,
  0x4000, 0x2ab3, 0x19d8, 0x007f, 0x007f, 0x19d8, 0x2ae9, 0x4006,
  0x2aac, 0x19a2, 0x007e, 0x007e, 0x007e, 0x19d8, 0x2ab2, 0x4000,
  0x199b, 0x0048, 0x007e, 0x007e, 0x007e, 0x19a1, 0x2aac, 0x3fff,
  0x0041, 0x0047, 0x007d, 0x007d, 0x0047, 0x199b, 0x2aab, 0x3fff,
  0x0047, 0x007d, 0x007d, 0x0047, 0x199b, 0x2aab, 0x3fff, 0x3fff,
  0x0047, 0x007d, 0x0047, 0x0041, 0x199a, 0x2aab, 0x3ffe, 0x3ffe,
  0x0046, 0x0046, 0x0040, 0x0040, 0x199a, 0x2aaa, 0x3ffe, 0x3ffe,
  0x0010, 0x0040, 0x0040, 0x0040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7,
  0x0009, 0x003f, 0x003f, 0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0,
  0x0009, 0x003f, 0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0,
  0x0008, 0x003e, 0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf,
  0x0008, 0x003e, 0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665,
  0x0007, 0x003d, 0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554,
  0x0007, 0x0036, 0x0000, 0x0000, 0x195a, 0x1111, 0x1554, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffc9, 0xffff, 0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff,
  0xffc9, 0xffff, 0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0x7fff,
  0xffc8, 0xe6a5, 0xd594, 0xc041, 0xd99a, 0xeaab, 0x7ffe, 0x7ffe,
  0xe66e, 0xd594, 0xc040, 0xc040, 0xd99a, 0x6aaa, 0x7ffe, 0x6aaa,
  0xd55d, 0xc040, 0xc040, 0xc040, 0x5999, 0x6aaa, 0x6aa9, 0x5999,
  0xc009, 0xc03f, 0xc03f, 0x403f, 0x5999, 0x5555, 0x5998, 0x403f,
  0xc009, 0xc03f, 0x403f, 0x403f, 0x4444, 0x4444, 0x403e, 0x403e,
  0xc008, 0x403e, 0x403e, 0x2aea, 0x3333, 0x2aea, 0x403e, 0x403e,
  0x4008, 0x403e, 0x2aea, 0x19d9, 0x19d9, 0x2aea, 0x403d, 0x403d,
  0x4007, 0x2ae9, 0x19d9, 0x007f, 0x19d9, 0x2ae9, 0x403d, 0x4007,
  0x2ab3, 0x19d8, 0x007f, 0x007f, 0x19d8, 0x2ae9, 0x4006, 0x4000,
  0x19a2, 0x007e, 0x007e, 0x007e, 0x19d8, 0x2ab2, 0x4000, 0x4000,
  0x0048, 0x007e, 0x007e, 0x007e, 0x19a1, 0x2aac, 0x3fff, 0x3fff,
  0x007e, 0x007e, 0x007e, 0x19a1, 0x2aac, 0x3fff, 0x3fff, 0x3fff,
  0x007d, 0x007d, 0x0047, 0x199b, 0x2aab, 0x3fff, 0x3fff, 0x3fff,
  0x007d, 0x0047, 0x0041, 0x199a, 0x2aab, 0x3ffe, 0x3ffe, 0x3ffe,
  0x0046, 0x0040, 0x0040, 0x199a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7,
  0x0040, 0x0040, 0x0040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1,
  0x003f, 0x003f, 0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0,
  0x003f, 0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0,
  0x003e, 0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666,
  0x003e, 0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555,
  0x003d, 0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001,
  0x0036, 0x0000, 0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0x7fff,
  0xffff, 0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0x7fff, 0x7fff,
  0xe6a5, 0xd594, 0xc041, 0xd99a, 0xeaab, 0x7ffe, 0x7ffe, 0x6aaa,
  0xd594, 0xc040, 0xc040, 0xd99a, 0x6aaa, 0x7ffe, 0x6aaa, 0x5999,
  0xc040, 0xc040, 0xc040, 0x5999, 0x6aaa, 0x6aa9, 0x5999, 0x403f,
  0xc03f, 0xc03f, 0x403f, 0x5999, 0x5555, 0x5998, 0x403f, 0x403f,
  0xc03f, 0x403f, 0x403f, 0x4444, 0x4444, 0x403e, 0x403e, 0x403e,
  0x403e, 0x403e, 0x2aea, 0x3333, 0x2aea, 0x403e, 0x403e, 0x403e,
  0x403e, 0x2aea, 0x19d9, 0x19d9, 0x2aea, 0x403d, 0x403d, 0x4007,
  0x2ae9, 0x19d9, 0x007f, 0x19d9, 0x2ae9, 0x403d, 0x4007, 0x4001,
  0x19d8, 0x007f, 0x007f, 0x19d8, 0x2ae9, 0x4006, 0x4000, 0x4000,
  0x007e, 0x007e, 0x007e, 0x19d8, 0x2ab2, 0x4000, 0x4000, 0x4000,
  0x007e, 0x007e, 0x19d8, 0x2ab2, 0x4000, 0x4000, 0x4000, 0xc000,
  0x007e, 0x007e, 0x19a1, 0x2aac, 0x3fff, 0x3fff, 0x3fff, 0xbfff,
  0x007d, 0x0047, 0x199b, 0x2aab, 0x3fff, 0x3fff, 0x3fff, 0xbfff,
  0x0047, 0x0041, 0x199a, 0x2aab, 0x3ffe, 0x3ffe, 0x3ffe, 0xbff8,
  0x0040, 0x0040, 0x199a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xbfc1,
  0x0040, 0x0040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xbfc1,
  0x003f, 0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xbfc0,
  0x003f, 0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xa666,
  0x003e, 0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x9555,
  0x003e, 0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x8001,
  0x0037, 0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0x8001,
  0x0000, 0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x8000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0x7fff, 0xffff,
  0xe6a5, 0xd595, 0xd99b, 0xeaab, 0xffff, 0x7fff, 0x7fff, 0xeaab,
  0xd594, 0xc041, 0xd99a, 0xeaab, 0x7ffe, 0x7ffe, 0x6aaa, 0xd99a,
  0xc040, 0xc040, 0xd99a, 0x6aaa, 0x7ffe, 0x6aaa, 0x5999, 0xc040,
  0xc040, 0xc040, 0x5999, 0x6aaa, 0x6aa9, 0x5999, 0x403f, 0xc03f,
  0xc03f, 0x403f, 0x5999, 0x5555, 0x5998, 0x403f, 0x403f, 0xc03f,
  0x403f, 0x403f, 0x4444, 0x4444, 0x403e, 0x403e, 0x403e, 0xc03e,
  0x403e, 0x2aea, 0x3333, 0x2aea, 0x403e, 0x403e, 0x403e, 0xc008,
  0x2aea, 0x19d9, 0x19d9, 0x2aea, 0x403d, 0x403d, 0x4007, 0xc001,
  0x19d9, 0x007f, 0x19d9, 0x2ae9, 0x403d, 0x4007, 0x4001, 0xc001,
  0x007f, 0x007f, 0x19d8, 0x2ae9, 0x4006, 0x4000, 0x4000, 0xc000,
  0x007f, 0x19d8, 0x2ae9, 0x4006, 0x4000, 0x4000, 0xc000, 0xc000,
  0x007e, 0x19d8, 0x2ab2, 0x4000, 0x4000, 0x4000, 0xc000, 0xc000,
  0x007e, 0x19a1, 0x2aac, 0x3fff, 0x3fff, 0x3fff, 0xbfff, 0xbfff,
  0x0047, 0x199b, 0x2aab, 0x3fff, 0x3fff, 0x3fff, 0xbfff, 0xbff8,
  0x0041, 0x199a, 0x2aab, 0x3ffe, 0x3ffe, 0x3ffe, 0xbff8, 0xbfc2,
  0x0040, 0x199a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xbfc1, 0xbfc1,
  0x0040, 0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xbfc1, 0xbfc1,
  0x003f, 0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xbfc0, 0xa667,
  0x003f, 0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xa666, 0x9556,
  0x003e, 0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x9555, 0x8002,
  0x0037, 0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x8001, 0x8001,
  0x0001, 0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0x8001, 0x8001,
  0x0000, 0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x8000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0xeeef, 0xeaac, 0xffff, 0xffff, 0x7fff, 0xffff, 0xeaab,
  0xd595, 0xd99b, 0xeaab, 0xffff, 0x7fff, 0x7fff, 0xeaab, 0xd99a,
  0xc041, 0xd99a, 0xeaab, 0x7ffe, 0x7ffe, 0x6aaa, 0xd99a, 0xc040,
  0xc040, 0xd99a, 0x6aaa, 0x7ffe, 0x6aaa, 0x5999, 0xc040, 0xc040,
  0xc040, 0x5999, 0x6aaa, 0x6aa9, 0x5999, 0x403f, 0xc03f, 0xc03f,
  0x403f, 0x5999, 0x5555, 0x5998, 0x403f, 0x403f, 0xc03f, 0xc03f,
  0x403f, 0x4444, 0x4444, 0x403e, 0x403e, 0x403e, 0xc03e, 0xc008,
  0x2aea, 0x3333, 0x2aea, 0x403e, 0x403e, 0x403e, 0xc008, 0xc002,
  0x19d9, 0x19d9, 0x2aea, 0x403d, 0x403d, 0x4007, 0xc001, 0xc001,
  0x007f, 0x19d9, 0x2ae9, 0x403d, 0x4007, 0x4001, 0xc001, 0xc001,
  0x19d9, 0x2ae9, 0x403d, 0x4007, 0x4001, 0xc001, 0xc001, 0xd555,
  0x19d8, 0x2ae9, 0x4006, 0x4000, 0x4000, 0xc000, 0xc000, 0xd554,
  0x19d8, 0x2ab2, 0x4000, 0x4000, 0x4000, 0xc000, 0xc000, 0xd554,
  0x19a1, 0x2aac, 0x3fff, 0x3fff, 0x3fff, 0xbfff, 0xbfff, 0xd54d,
  0x199b, 0x2aab, 0x3fff, 0x3fff, 0x3fff, 0xbfff, 0xbff8, 0xd516,
  0x199a, 0x2aab, 0x3ffe, 0x3ffe, 0x3ffe, 0xbff8, 0xbfc2, 0xd516,
  0x199a, 0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xbfc1, 0xbfc1, 0xd515,
  0x1999, 0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xbfc1, 0xbfc1, 0xbbbb,
  0x1999, 0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xbfc0, 0xa667, 0xaaaa,
  0x1998, 0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xa666, 0x9556, 0x9556,
  0x1991, 0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x9555, 0x8002, 0x9556,
  0x195b, 0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x8001, 0x8001, 0x9555,
  0x195a, 0x2a6b, 0x2665, 0x1554, 0x0001, 0x8001, 0x8001, 0x1555,
  0x195a, 0x1111, 0x1554, 0x0000, 0x0000, 0x8000, 0x0000, 0x1554,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0xeaac, 0xffff, 0xffff, 0x7fff, 0xffff, 0xeaab, 0xeeef,
  0xd99b, 0xeaab, 0xffff, 0x7fff, 0x7fff, 0xeaab, 0xd99a, 0xd595,
  0xd99a, 0xeaab, 0x7ffe, 0x7ffe, 0x6aaa, 0xd99a, 0xc040, 0xd594,
  0xd99a, 0x6aaa, 0x7ffe, 0x6aaa, 0x5999, 0xc040, 0xc040, 0xd594,
  0x5999, 0x6aaa, 0x6aa9, 0x5999, 0x403f, 0xc03f, 0xc03f, 0xd593,
  0x5999, 0x5555, 0x5998, 0x403f, 0x403f, 0xc03f, 0xc03f, 0xd55d,
  0x4444, 0x4444, 0x403e, 0x403e, 0x403e, 0xc03e, 0xc008, 0xd556,
  0x3333, 0x2aea, 0x403e, 0x403e, 0x403e, 0xc008, 0xc002, 0xd556,
  0x19d9, 0x2aea, 0x403d, 0x403d, 0x4007, 0xc001, 0xc001, 0xd555,
  0x2aea, 0x403d, 0x403d, 0x4007, 0xc001, 0xc001, 0xd555, 0xe666,
  0x2ae9, 0x403d, 0x4007, 0x4001, 0xc001, 0xc001, 0xd555, 0xe665,
  0x2ae9, 0x4006, 0x4000, 0x4000, 0xc000, 0xc000, 0xd554, 0xe665,
  0x2ab2, 0x4000, 0x4000, 0x4000, 0xc000, 0xc000, 0xd554, 0xe65e,
  0x2aac, 0x3fff, 0x3fff, 0x3fff, 0xbfff, 0xbfff, 0xd54d, 0xe627,
  0x2aab, 0x3fff, 0x3fff, 0x3fff, 0xbfff, 0xbff8, 0xd516, 0xe627,
  0x2aab, 0x3ffe, 0x3ffe, 0x3ffe, 0xbff8, 0xbfc2, 0xd516, 0xe626,
  0x2aaa, 0x3ffe, 0x3ffe, 0x3ff7, 0xbfc1, 0xbfc1, 0xd515, 0xcccc,
  0x2aaa, 0x3ffd, 0x3ff7, 0x3fc1, 0xbfc1, 0xbfc1, 0xbbbb, 0xbbbb,
  0x2aa9, 0x3ff6, 0x3fc0, 0x3fc0, 0xbfc0, 0xa667, 0xaaaa, 0xa667,
  0x2aa2, 0x3fc0, 0x3fc0, 0x3fc0, 0xa666, 0x9556, 0x9556, 0xa667,
  0x2a6c, 0x3fbf, 0x3fbf, 0x2666, 0x9555, 0x8002, 0x9556, 0xa666,
  0x2a6b, 0x3fbf, 0x2665, 0x1555, 0x8001, 0x8001, 0x9555, 0x2666,
  0x2a6b, 0x2665, 0x1554, 0x0001, 0x8001, 0x8001, 0x1555, 0x2665,
  0x1111, 0x1554, 0x0000, 0x0000, 0x8000, 0x0000, 0x1554, 0x1111,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaac, 0xffff, 0xffff, 0x7fff, 0xffff, 0xeaab, 0xeeef, 0xe6a6,
  0xeaab, 0xffff, 0x7fff, 0x7fff, 0xeaab, 0xd99a, 0xd595, 0xe6a5,
  0xeaab, 0x7ffe, 0x7ffe, 0x6aaa, 0xd99a, 0xc040, 0xd594, 0xe6a5,
  0x6aaa, 0x7ffe, 0x6aaa, 0x5999, 0xc040, 0xc040, 0xd594, 0xe6a4,
  0x6aaa, 0x6aa9, 0x5999, 0x403f, 0xc03f, 0xc03f, 0xd593, 0xe66e,
  0x5555, 0x5998, 0x403f, 0x403f, 0xc03f, 0xc03f, 0xd55d, 0xe667,
  0x4444, 0x403e, 0x403e, 0x403e, 0xc03e, 0xc008, 0xd556, 0xe667,
  0x2aea, 0x403e, 0x403e, 0x403e, 0xc008, 0xc002, 0xd556, 0xe666,
  0x403e, 0x403e, 0x403e, 0xc008, 0xc002, 0xd556, 0xe666, 0xffc0,
  0x403d, 0x403d, 0x4007, 0xc001, 0xc001, 0xd555, 0xe666, 0xffbf,
  0x403d, 0x4007, 0x4001, 0xc001, 0xc001, 0xd555, 0xe665, 0xffbf,
  0x4006, 0x4000, 0x4000, 0xc000, 0xc000, 0xd554, 0xe665, 0xffb8,
  0x4000, 0x4000, 0x4000, 0xc000, 0xc000, 0xd554, 0xe65e, 0xff81,
  0x3fff, 0x3fff, 0x3fff, 0xbfff, 0xbfff, 0xd54d, 0xe627, 0xff81,
  0x3fff, 0x3fff, 0x3fff, 0xbfff, 0xbff8, 0xd516, 0xe627, 0xff80,
  0x3ffe, 0x3ffe, 0x3ffe, 0xbff8, 0xbfc2, 0xd516, 0xe626, 0xe626,
  0x3ffe, 0x3ffe, 0x3ff7, 0xbfc1, 0xbfc1, 0xd515, 0xcccc, 0xd515,
  0x3ffd, 0x3ff7, 0x3fc1, 0xbfc1, 0xbfc1, 0xbbbb, 0xbbbb, 0xbfc1,
  0x3ff6, 0x3fc0, 0x3fc0, 0xbfc0, 0xa667, 0xaaaa, 0xa667, 0xbfc1,
  0x3fc0, 0x3fc0, 0x3fc0, 0xa666, 0x9556, 0x9556, 0xa667, 0xbfc0,
  0x3fbf, 0x3fbf, 0x2666, 0x9555, 0x8002, 0x9556, 0xa666, 0x3fc0,
  0x3fbf, 0x2665, 0x1555, 0x8001, 0x8001, 0x9555, 0x2666, 0x3fbf,
  0x2665, 0x1554, 0x0001, 0x8001, 0x8001, 0x1555, 0x2665, 0x2a6b,
  0x1554, 0x0000, 0x0000, 0x8000, 0x0000, 0x1554, 0x1111, 0x195a,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xffff, 0x7fff, 0xffff, 0xeaab, 0xeeef, 0xe6a6, 0xffff,
  0xffff, 0x7fff, 0x7fff, 0xeaab, 0xd99a, 0xd595, 0xe6a5, 0xffff,
  0x7ffe, 0x7ffe, 0x6aaa, 0xd99a, 0xc040, 0xd594, 0xe6a5, 0xfffe,
  0x7ffe, 0x6aaa, 0x5999, 0xc040, 0xc040, 0xd594, 0xe6a4, 0xffc8,
  0x6aa9, 0x5999, 0x403f, 0xc03f, 0xc03f, 0xd593, 0xe66e, 0xffc1,
  0x5998, 0x403f, 0x403f, 0xc03f, 0xc03f, 0xd55d, 0xe667, 0xffc1,
  0x403e, 0x403e, 0x403e, 0xc03e, 0xc008, 0xd556, 0xe667, 0xffc0,
  0x403e, 0x403e, 0xc03e, 0xc008, 0xd556, 0xe667, 0xffc0, 0xffc0,
  0x403e, 0x403e, 0xc008, 0xc002, 0xd556, 0xe666, 0xffc0, 0xffc0,
  0x403d, 0x4007, 0xc001, 0xc001, 0xd555, 0xe666, 0xffbf, 0xffbf,
  0x4007, 0x4001, 0xc001, 0xc001, 0xd555, 0xe665, 0xffbf, 0xffb8,
  0x4000, 0x4000, 0xc000, 0xc000, 0xd554, 0xe665, 0xffb8, 0xff82,
  0x4000, 0x4000, 0xc000, 0xc000, 0xd554, 0xe65e, 0xff81, 0xff81,
  0x3fff, 0x3fff, 0xbfff, 0xbfff, 0xd54d, 0xe627, 0xff81, 0xff81,
  0x3fff, 0x3fff, 0xbfff, 0xbff8, 0xd516, 0xe627, 0xff80, 0xe627,
  0x3ffe, 0x3ffe, 0xbff8, 0xbfc2, 0xd516, 0xe626, 0xe626, 0xd516,
  0x3ffe, 0x3ff7, 0xbfc1, 0xbfc1, 0xd515, 0xcccc, 0xd515, 0xbfc2,
  0x3ff7, 0x3fc1, 0xbfc1, 0xbfc1, 0xbbbb, 0xbbbb, 0xbfc1, 0xbfc1,
  0x3fc0, 0x3fc0, 0xbfc0, 0xa667, 0xaaaa, 0xa667, 0xbfc1, 0xbfc1,
  0x3fc0, 0x3fc0, 0xa666, 0x9556, 0x9556, 0xa667, 0xbfc0, 0x3fc0,
  0x3fbf, 0x2666, 0x9555, 0x8002, 0x9556, 0xa666, 0x3fc0, 0x3fc0,
  0x2665, 0x1555, 0x8001, 0x8001, 0x9555, 0x2666, 0x3fbf, 0x2a6b,
  0x1554, 0x0001, 0x8001, 0x8001, 0x1555, 0x2665, 0x2a6b, 0x195a,
  0x0000, 0x0000, 0x8000, 0x0000, 0x1554, 0x1111, 0x195a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0x7fff, 0xffff, 0xeaab, 0xeeef, 0xe6a6, 0xffff, 0xffff,
  0x7fff, 0x7fff, 0xeaab, 0xd99a, 0xd595, 0xe6a5, 0xffff, 0xffff,
  0x7ffe, 0x6aaa, 0xd99a, 0xc040, 0xd594, 0xe6a5, 0xfffe, 0xffc8,
  0x6aaa, 0x5999, 0xc040, 0xc040, 0xd594, 0xe6a4, 0xffc8, 0xffc2,
  0x5999, 0x403f, 0xc03f, 0xc03f, 0xd593, 0xe66e, 0xffc1, 0xffc1,
  0x403f, 0x403f, 0xc03f, 0xc03f, 0xd55d, 0xe667, 0xffc1, 0xffc1,
  0x403f, 0xc03f, 0xc03f, 0xd55d, 0xe667, 0xffc1, 0xffc1, 0xffc1,
  0x403e, 0xc03e, 0xc008, 0xd556, 0xe667, 0xffc0, 0xffc0, 0xffc0,
  0x403e, 0xc008, 0xc002, 0xd556, 0xe666, 0xffc0, 0xffc0, 0xffc0,
  0x4007, 0xc001, 0xc001, 0xd555, 0xe666, 0xffbf, 0xffbf, 0xffb9,
  0x4001, 0xc001, 0xc001, 0xd555, 0xe665, 0xffbf, 0xffb8, 0xff82,
  0x4000, 0xc000, 0xc000, 0xd554, 0xe665, 0xffb8, 0xff82, 0xff82,
  0x4000, 0xc000, 0xc000, 0xd554, 0xe65e, 0xff81, 0xff81, 0xff81,
  0x3fff, 0xbfff, 0xbfff, 0xd54d, 0xe627, 0xff81, 0xff81, 0xe627,
  0x3fff, 0xbfff, 0xbff8, 0xd516, 0xe627, 0xff80, 0xe627, 0xd516,
  0x3ffe, 0xbff8, 0xbfc2, 0xd516, 0xe626, 0xe626, 0xd516, 0xbfc2,
  0x3ff7, 0xbfc1, 0xbfc1, 0xd515, 0xcccc, 0xd515, 0xbfc2, 0xbfc2,
  0x3fc1, 0xbfc1, 0xbfc1, 0xbbbb, 0xbbbb, 0xbfc1, 0xbfc1, 0xbfc1,
  0x3fc0, 0xbfc0, 0xa667, 0xaaaa, 0xa667, 0xbfc1, 0xbfc1, 0x3fc1,
  0x3fc0, 0xa666, 0x9556, 0x9556, 0xa667, 0xbfc0, 0x3fc0, 0x3fc0,
  0x2666, 0x9555, 0x8002, 0x9556, 0xa666, 0x3fc0, 0x3fc0, 0x2a6c,
  0x1555, 0x8001, 0x8001, 0x9555, 0x2666, 0x3fbf, 0x2a6b, 0x195b,
  0x0001, 0x8001, 0x8001, 0x1555, 0x2665, 0x2a6b, 0x195a, 0x0001,
  0x0000, 0x8000, 0x0000, 0x1554, 0x1111, 0x195a, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7fff, 0xffff, 0xeaab, 0xeeef, 0xe6a6, 0xffff, 0xffff, 0xffff,
  0x7fff, 0xeaab, 0xd99a, 0xd595, 0xe6a5, 0xffff, 0xffff, 0xffc9,
  0x6aaa, 0xd99a, 0xc040, 0xd594, 0xe6a5, 0xfffe, 0xffc8, 0xffc2,
  0x5999, 0xc040, 0xc040, 0xd594, 0xe6a4, 0xffc8, 0xffc2, 0xffc2,
  0x403f, 0xc03f, 0xc03f, 0xd593, 0xe66e, 0xffc1, 0xffc1, 0xffc1,
  0xc03f, 0xc03f, 0xd593, 0xe66e, 0xffc1, 0xffc1, 0xffc1, 0xffc1,
  0xc03f, 0xc03f, 0xd55d, 0xe667, 0xffc1, 0xffc1, 0xffc1, 0xffc1,
  0xc03e, 0xc008, 0xd556, 0xe667, 0xffc0, 0xffc0, 0xffc0, 0xffc0,
  0xc008, 0xc002, 0xd556, 0xe666, 0xffc0, 0xffc0, 0xffc0, 0xffb9,
  0xc001, 0xc001, 0xd555, 0xe666, 0xffbf, 0xffbf, 0xffb9, 0xff83,
  0xc001, 0xc001, 0xd555, 0xe665, 0xffbf, 0xffb8, 0xff82, 0xff82,
  0xc000, 0xc000, 0xd554, 0xe665, 0xffb8, 0xff82, 0xff82, 0xff82,
  0xc000, 0xc000, 0xd554, 0xe65e, 0xff81, 0xff81, 0xff81, 0xe628,
  0xbfff, 0xbfff, 0xd54d, 0xe627, 0xff81, 0xff81, 0xe627, 0xd517,
  0xbfff, 0xbff8, 0xd516, 0xe627, 0xff80, 0xe627, 0xd516, 0xbfc3,
  0xbff8, 0xbfc2, 0xd516, 0xe626, 0xe626, 0xd516, 0xbfc2, 0xbfc2,
  0xbfc1, 0xbfc1, 0xd515, 0xcccc, 0xd515, 0xbfc2, 0xbfc2, 0xbfc2,
  0xbfc1, 0xbfc1, 0xbbbb, 0xbbbb, 0xbfc1, 0xbfc1, 0xbfc1, 0x3fc1,
  0xbfc0, 0xa667, 0xaaaa, 0xa667, 0xbfc1, 0xbfc1, 0x3fc1, 0x3fc1,
  0xa666, 0x9556, 0x9556, 0xa667, 0xbfc0, 0x3fc0, 0x3fc0, 0x2a6c,
  0x9555, 0x8002, 0x9556, 0xa666, 0x3fc0, 0x3fc0, 0x2a6c, 0x195b,
  0x8001, 0x8001, 0x9555, 0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0001,
  0x8001, 0x8001, 0x1555, 0x2665, 0x2a6b, 0x195a, 0x0001, 0x0001,
  0x8000, 0x0000, 0x1554, 0x1111, 0x195a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xffff, 0xeaab, 0xeeef, 0xe6a6, 0xffff, 0xffff, 0xffff, 0xffc9,
  0xeaab, 0xd99a, 0xd595, 0xe6a5, 0xffff, 0xffff, 0xffc9, 0xffc3,
  0xd99a, 0xc040, 0xd594, 0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0xffc2,
  0xc040, 0xc040, 0xd594, 0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0xffc2,
  0xc040, 0xd594, 0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0xffc2, 0xfff8,
  0xc03f, 0xd593, 0xe66e, 0xffc1, 0xffc1, 0xffc1, 0xffc1, 0xfff7,
  0xc03f, 0xd55d, 0xe667, 0xffc1, 0xffc1, 0xffc1, 0xffc1, 0xfff7,
  0xc008, 0xd556, 0xe667, 0xffc0, 0xffc0, 0xffc0, 0xffc0, 0xfff0,
  0xc002, 0xd556, 0xe666, 0xffc0, 0xffc0, 0xffc0, 0xffb9, 0xffb9,
  0xc001, 0xd555, 0xe666, 0xffbf, 0xffbf, 0xffb9, 0xff83, 0xffb9,
  0xc001, 0xd555, 0xe665, 0xffbf, 0xffb8, 0xff82, 0xff82, 0xffb8,
  0xc000, 0xd554, 0xe665, 0xffb8, 0xff82, 0xff82, 0xff82, 0xe65e,
  0xc000, 0xd554, 0xe65e, 0xff81, 0xff81, 0xff81, 0xe628, 0xd54d,
  0xbfff, 0xd54d, 0xe627, 0xff81, 0xff81, 0xe627, 0xd517, 0xbff9,
  0xbff8, 0xd516, 0xe627, 0xff80, 0xe627, 0xd516, 0xbfc3, 0xbff9,
  0xbfc2, 0xd516, 0xe626, 0xe626, 0xd516, 0xbfc2, 0xbfc2, 0xbff8,
  0xbfc1, 0xd515, 0xcccc, 0xd515, 0xbfc2, 0xbfc2, 0xbfc2, 0x3ff8,
  0xbfc1, 0xbbbb, 0xbbbb, 0xbfc1, 0xbfc1, 0xbfc1, 0x3fc1, 0x3ff7,
  0xa667, 0xaaaa, 0xa667, 0xbfc1, 0xbfc1, 0x3fc1, 0x3fc1, 0x2aa3,
  0x9556, 0x9556, 0xa667, 0xbfc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x1992,
  0x8002, 0x9556, 0xa666, 0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0038,
  0x8001, 0x9555, 0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0037,
  0x8001, 0x1555, 0x2665, 0x2a6b, 0x195a, 0x0001, 0x0001, 0x0037,
  0x0000, 0x1554, 0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0036,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeaab, 0xeeef, 0xe6a6, 0xffff, 0xffff, 0xffff, 0xffc9, 0xfff9,
  0xd99a, 0xd595, 0xe6a5, 0xffff, 0xffff, 0xffc9, 0xffc3, 0xfff9,
  0xc040, 0xd594, 0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0xffc2, 0xfff8,
  0xd594, 0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0xffc2, 0xfff8, 0xfffe,
  0xd594, 0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0xffc2, 0xfff8, 0xfffe,
  0xd593, 0xe66e, 0xffc1, 0xffc1, 0xffc1, 0xffc1, 0xfff7, 0xfffd,
  0xd55d, 0xe667, 0xffc1, 0xffc1, 0xffc1, 0xffc1, 0xfff7, 0xfff6,
  0xd556, 0xe667, 0xffc0, 0xffc0, 0xffc0, 0xffc0, 0xfff0, 0xffc0,
  0xd556, 0xe666, 0xffc0, 0xffc0, 0xffc0, 0xffb9, 0xffb9, 0xffbf,
  0xd555, 0xe666, 0xffbf, 0xffbf, 0xffb9, 0xff83, 0xffb9, 0xffbf,
  0xd555, 0xe665, 0xffbf, 0xffb8, 0xff82, 0xff82, 0xffb8, 0xe665,
  0xd554, 0xe665, 0xffb8, 0xff82, 0xff82, 0xff82, 0xe65e, 0xd554,
  0xd554, 0xe65e, 0xff81, 0xff81, 0xff81, 0xe628, 0xd54d, 0xc000,
  0xd54d, 0xe627, 0xff81, 0xff81, 0xe627, 0xd517, 0xbff9, 0xbfff,
  0xd516, 0xe627, 0xff80, 0xe627, 0xd516, 0xbfc3, 0xbff9, 0xbfff,
  0xd516, 0xe626, 0xe626, 0xd516, 0xbfc2, 0xbfc2, 0xbff8, 0x3ffe,
  0xd515, 0xcccc, 0xd515, 0xbfc2, 0xbfc2, 0xbfc2, 0x3ff8, 0x3ffe,
  0xbbbb, 0xbbbb, 0xbfc1, 0xbfc1, 0xbfc1, 0x3fc1, 0x3ff7, 0x2aa9,
  0xaaaa, 0xa667, 0xbfc1, 0xbfc1, 0x3fc1, 0x3fc1, 0x2aa3, 0x1998,
  0x9556, 0xa667, 0xbfc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x1992, 0x003e,
  0x9556, 0xa666, 0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0038, 0x003e,
  0x9555, 0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0037, 0x003d,
  0x1555, 0x2665, 0x2a6b, 0x195a, 0x0001, 0x0001, 0x0037, 0x003d,
  0x1554, 0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0036, 0x0006,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xeeef, 0xe6a6, 0xffff, 0xffff, 0xffff, 0xffc9, 0xfff9, 0xffff,
  0xd595, 0xe6a5, 0xffff, 0xffff, 0xffc9, 0xffc3, 0xfff9, 0xffff,
  0xe6a5, 0xffff, 0xffff, 0xffc9, 0xffc3, 0xfff9, 0xffff, 0xffff,
  0xe6a5, 0xfffe, 0xffc8, 0xffc2, 0xffc2, 0xfff8, 0xfffe, 0xfffe,
  0xe6a4, 0xffc8, 0xffc2, 0xffc2, 0xffc2, 0xfff8, 0xfffe, 0xfffe,
  0xe66e, 0xffc1, 0xffc1, 0xffc1, 0xffc1, 0xfff7, 0xfffd, 0xfff7,
  0xe667, 0xffc1, 0xffc1, 0xffc1, 0xffc1, 0xfff7, 0xfff6, 0xffc0,
  0xe667, 0xffc0, 0xffc0, 0xffc0, 0xffc0, 0xfff0, 0xffc0, 0xffc0,
  0xe666, 0xffc0, 0xffc0, 0xffc0, 0xffb9, 0xffb9, 0xffbf, 0xffbf,
  0xe666, 0xffbf, 0xffbf, 0xffb9, 0xff83, 0xffb9, 0xffbf, 0xe665,
  0xe665, 0xffbf, 0xffb8, 0xff82, 0xff82, 0xffb8, 0xe665, 0xd554,
  0xe665, 0xffb8, 0xff82, 0xff82, 0xff82, 0xe65e, 0xd554, 0xc000,
  0xe65e, 0xff81, 0xff81, 0xff81, 0xe628, 0xd54d, 0xc000, 0xc000,
  0xe627, 0xff81, 0xff81, 0xe627, 0xd517, 0xbff9, 0xbfff, 0xbfff,
  0xe627, 0xff80, 0xe627, 0xd516, 0xbfc3, 0xbff9, 0xbfff, 0x3fff,
  0xe626, 0xe626, 0xd516, 0xbfc2, 0xbfc2, 0xbff8, 0x3ffe, 0x3ffe,
  0xcccc, 0xd515, 0xbfc2, 0xbfc2, 0xbfc2, 0x3ff8, 0x3ffe, 0x2aaa,
  0xbbbb, 0xbfc1, 0xbfc1, 0xbfc1, 0x3fc1, 0x3ff7, 0x2aa9, 0x1999,
  0xa667, 0xbfc1, 0xbfc1, 0x3fc1, 0x3fc1, 0x2aa3, 0x1998, 0x003f,
  0xa667, 0xbfc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x1992, 0x003e, 0x003e,
  0xa666, 0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0038, 0x003e, 0x003e,
  0x2666, 0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0037, 0x003d, 0x003d,
  0x2665, 0x2a6b, 0x195a, 0x0001, 0x0001, 0x0037, 0x003d, 0x0007,
  0x1111, 0x195a, 0x0000, 0x0000, 0x0000, 0x0036, 0x0006, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0xe6a6, 0xffff, 0xffff, 0xffff, 0xffc9, 0xfff9, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffff, 0xffc9, 0xfff9, 0xffff, 0xffff, 0xffff,
  0xffff, 0xffff, 0xffc9, 0xffc3, 0xfff9, 0xffff, 0xffff, 0xffff,
  0xfffe, 0xffc8, 0xffc2, 0xffc2, 0xfff8, 0xfffe, 0xfffe, 0xfffe,
  0xffc8, 0xffc2, 0xffc2, 0xffc2, 0xfff8, 0xfffe, 0xfffe, 0xfff7,
  0xffc1, 0xffc1, 0xffc1, 0xffc1, 0xfff7, 0xfffd, 0xfff7, 0xffc1,
  0xffc1, 0xffc1, 0xffc1, 0xffc1, 0xfff7, 0xfff6, 0xffc0, 0xffc0,
  0xffc0, 0xffc0, 0xffc0, 0xffc0, 0xfff0, 0xffc0, 0xffc0, 0xffc0,
  0xffc0, 0xffc0, 0xffc0, 0xffb9, 0xffb9, 0xffbf, 0xffbf, 0xe666,
  0xffbf, 0xffbf, 0xffb9, 0xff83, 0xffb9, 0xffbf, 0xe665, 0xd555,
  0xffbf, 0xffb8, 0xff82, 0xff82, 0xffb8, 0xe665, 0xd554, 0xc001,
  0xffb8, 0xff82, 0xff82, 0xff82, 0xe65e, 0xd554, 0xc000, 0xc000,
  0xff81, 0xff81, 0xff81, 0xe628, 0xd54d, 0xc000, 0xc000, 0xc000,
  0xff81, 0xff81, 0xe627, 0xd517, 0xbff9, 0xbfff, 0xbfff, 0x3fff,
  0xff80, 0xe627, 0xd516, 0xbfc3, 0xbff9, 0xbfff, 0x3fff, 0x3fff,
  0xe626, 0xd516, 0xbfc2, 0xbfc2, 0xbff8, 0x3ffe, 0x3ffe, 0x2aaa,
  0xd515, 0xbfc2, 0xbfc2, 0xbfc2, 0x3ff8, 0x3ffe, 0x2aaa, 0x1999,
  0xbfc1, 0xbfc1, 0xbfc1, 0x3fc1, 0x3ff7, 0x2aa9, 0x1999, 0x003f,
  0xbfc1, 0xbfc1, 0x3fc1, 0x3fc1, 0x2aa3, 0x1998, 0x003f, 0x003f,
  0xbfc0, 0x3fc0, 0x3fc0, 0x2a6c, 0x1992, 0x003e, 0x003e, 0x003e,
  0x3fc0, 0x3fc0, 0x2a6c, 0x195b, 0x0038, 0x003e, 0x003e, 0x003e,
  0x3fbf, 0x2a6b, 0x195b, 0x0001, 0x0037, 0x003d, 0x003d, 0x0007,
  0x2a6b, 0x195a, 0x0001, 0x0001, 0x0037, 0x003d, 0x0007, 0x0001,
  0x195a, 0x0000, 0x0000, 0x0000, 0x0036, 0x0006, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
};
const unsigned kExpectedCount_NEON_shsub_8H = 576;

#endif  // VIXL_SIM_SHSUB_8H_TRACE_AARCH64_H_
