/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.renderer.java3d.geom;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import org.j3d.geom.ConeGenerator;
import org.j3d.geom.GeometryData;

public class Cone
extends Shape3D {
    private static final float DEFAULT_HEIGHT = 2.0f;
    private static final float DEFAULT_RADIUS = 1.0f;
    private static final int DEFAULT_FACETS = 16;
    private ConeGenerator generator;
    private GeometryData data = new GeometryData();

    public Cone() {
        this(2.0f, 1.0f, 16, null);
    }

    public Cone(Appearance appearance) {
        this(2.0f, 1.0f, 16, appearance);
    }

    public Cone(int n) {
        this(2.0f, 1.0f, n, null);
    }

    public Cone(float f, float f2) {
        this(f, f2, 16, null);
    }

    public Cone(int n, Appearance appearance) {
        this(2.0f, 1.0f, n, appearance);
    }

    public Cone(float f, float f2, Appearance appearance) {
        this(f, f2, 16, appearance);
    }

    public Cone(float f, float f2, int n, Appearance appearance) {
        this.data.geometryType = 1;
        this.data.geometryComponents = 2;
        this.generator = new ConeGenerator(f, f2, n);
        this.generator.generate(this.data);
        int n2 = 3;
        TriangleArray triangleArray = new TriangleArray(this.data.vertexCount, n2);
        triangleArray.setCoordinates(0, this.data.coordinates);
        triangleArray.setNormals(0, this.data.normals);
        triangleArray.setUserData((Object)this.data);
        this.setCapability(13);
        this.setAppearance(appearance);
        this.setGeometry((Geometry)triangleArray);
    }

    public void setDimensions(float f, float f2) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setDimensions(f, f2, true);
        this.generator.generate(this.data);
        int n = 3;
        TriangleArray triangleArray = new TriangleArray(this.data.vertexCount, n);
        triangleArray.setCoordinates(0, this.data.coordinates);
        triangleArray.setNormals(0, this.data.normals);
        triangleArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleArray);
    }

    public void setFacetCount(int n) {
        if (!this.getCapability(13)) {
            return;
        }
        this.generator.setFacetCount(n);
        this.generator.generate(this.data);
        int n2 = 3;
        TriangleArray triangleArray = new TriangleArray(this.data.vertexCount, n2);
        triangleArray.setCoordinates(0, this.data.coordinates);
        triangleArray.setNormals(0, this.data.normals);
        triangleArray.setUserData((Object)this.data);
        this.setGeometry((Geometry)triangleArray);
    }
}

