/* msm-dri.c
 *
 * Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Code Aurora nor
 *       the names of its contributors may be used to endorse or promote
 *       products derived from this software without specific prior written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NON-INFRINGEMENT ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include "xf86.h"

#define _XF86DRI_SERVER_
#include "GL/glxtokens.h"
#include "sarea.h"

#include "msm.h"

#define MSM_USE_DBUFFER 1
#define MSM_USE_STENCIL 1
#define MSM_USE_DEPTH   1

static Bool
MSMCreateContext(ScreenPtr pScreen, VisualPtr visual,
		 drm_context_t hwContext, void *pVisualConfigPriv,
		 DRIContextType contextStore)
{
   return TRUE;
}

static void
MSMDestroyContext(ScreenPtr pScreen, drm_context_t hwContext,
		  DRIContextType contextStore)
{
}

/* NOTE: This handles 2D vs 3D swapping */

/* This gets called every time SwapBuffers is called on the other side */

static void
MSMDRISwapContext(ScreenPtr pScreen, DRISyncType syncType,
		  DRIContextType oldContextType,
		  void *oldContext,
		  DRIContextType newContextType, void *newContext)
{
}

static void
MSMDRIInitBuffers(WindowPtr pWin, RegionPtr prgn, CARD32 index)
{
}

static void
MSMDRIMoveBuffers(WindowPtr pParent, DDXPointRec ptOldOrg,
		  RegionPtr prgnSrc, CARD32 indx)
{
}

void
MSMDRICloseScreen(ScreenPtr pScreen)
{
   ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];

   MSMPtr pMsm = MSMPTR(pScrn);

   MSMDRIPrivPtr pMSMDRI = (MSMDRIPrivPtr)
	 pMsm->dri->pDRIInfo->devPrivate;

   if (pMSMDRI)
      xfree(pMSMDRI);

   DRICloseScreen(pScreen);
   DRIDestroyInfoRec(pMsm->dri->pDRIInfo);

   pMsm->dri->pDRIInfo = NULL;
}

static Bool
MSMDRIDoCloseScreen(int scrnIndex, ScreenPtr pScreen)
{
   ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];

   MSMPtr pMsm = MSMPTR(pScrn);

   MSMDRICloseScreen(pScreen);

   pScreen->CloseScreen = pMsm->dri->DRICloseScreen;
   return (*pScreen->CloseScreen) (scrnIndex, pScreen);
}

static void
MSMDRIClipNotify(ScreenPtr pScreen, WindowPtr * ppWin, int num)
{
}

Bool
MSMDRIScreenInit(ScreenPtr pScreen)
{
   ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];

   MSMPtr pMsm = MSMPTR(pScrn);

   DRIInfoPtr pDRIInfo;

   MSMDRIPrivPtr pMSMDRI;

   pMsm->dri->DRICloseScreen = NULL;

   pDRIInfo = DRICreateInfoRec();

   if (pDRIInfo == NULL)
      return FALSE;
   pMsm->dri->pDRIInfo = pDRIInfo;

   pDRIInfo->drmDriverName = "msm_kgsl";
   pDRIInfo->clientDriverName = "yamato";
   pDRIInfo->busIdString = xalloc(16);
   strcpy(pDRIInfo->busIdString, "platform:kgsl");

   pDRIInfo->ddxDriverMajorVersion = 1;
   pDRIInfo->ddxDriverMinorVersion = 0;
   pDRIInfo->ddxDriverPatchVersion = 0;

   pDRIInfo->frameBufferPhysicalAddress = (void *)pMsm->fixed_info.smem_start;

   pDRIInfo->frameBufferSize = pMsm->fixed_info.smem_len;
   pDRIInfo->frameBufferStride = pMsm->fixed_info.line_length;

   /* FIXME: How many drawables can we do (should we do)? */

   pDRIInfo->ddxDrawableTableEntry = 32;
   pDRIInfo->maxDrawableTableEntry = 32;

   /* Just allocate the maximum chunk of memory for the DRI
    * structures */

   pDRIInfo->SAREASize = SAREA_MAX;

   pMSMDRI = (MSMDRIPrivPtr) xcalloc(1, sizeof(*pMSMDRI));

   if (pMSMDRI == NULL) {
      DRIDestroyInfoRec(pMsm->dri->pDRIInfo);
      pMsm->dri->pDRIInfo = NULL;
      return FALSE;
   }

   pDRIInfo->devPrivate = pMSMDRI;
   pDRIInfo->devPrivateSize = sizeof(*pMSMDRI);

   pDRIInfo->contextSize = sizeof(MSMDRIContextRec);

   pDRIInfo->CreateContext = MSMCreateContext;
   pDRIInfo->DestroyContext = MSMDestroyContext;
   pDRIInfo->SwapContext = MSMDRISwapContext;
   pDRIInfo->InitBuffers = MSMDRIInitBuffers;
   pDRIInfo->MoveBuffers = MSMDRIMoveBuffers;
   pDRIInfo->bufferRequests = DRI_ALL_WINDOWS;
   pDRIInfo->ClipNotify = MSMDRIClipNotify;

   /* FIXME:  What else do I need to define in this structure? */

   pDRIInfo->createDummyCtx = TRUE;
   pDRIInfo->createDummyCtxPriv = FALSE;

   if (!DRIScreenInit(pScreen, pDRIInfo, &pMsm->dri->drmFD)) {
      xf86DrvMsg(pScreen->myNum, X_ERROR,
		 "MSM-DRI DRIScreenInit failed.  Disabling DRI.\n");
      xfree(pDRIInfo->devPrivate);
      pDRIInfo->devPrivate = NULL;
      DRIDestroyInfoRec(pDRIInfo);
      pDRIInfo = NULL;
      return FALSE;
   }

   xf86DrvMsg(pScreen->myNum, X_INFO, "[dri] MSM-DRI is initialized.\n");

   return TRUE;
}

Bool
MSMDRIFinishScreenInit(ScreenPtr pScreen)
{
   ScrnInfoPtr pScrn = xf86Screens[pScreen->myNum];

   MSMPtr pMsm = MSMPTR(pScrn);

   MSMDRIPrivPtr pMSMDRI;

   /*FIXME:  WHat is this? */
   pMsm->dri->pDRIInfo->driverSwapMethod = DRI_HIDE_X_CONTEXT;

   if (!DRIFinishScreenInit(pScreen)) {
      MSMDRICloseScreen(pScreen);
      return FALSE;
   }

   pMSMDRI = (MSMDRIPrivPtr) pMsm->dri->pDRIInfo->devPrivate;
   pMSMDRI->bpp = pScrn->bitsPerPixel;

   pMsm->dri->DRICloseScreen = pScreen->CloseScreen;
   pScreen->CloseScreen = MSMDRIDoCloseScreen;

   return TRUE;
}
